/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.conditionEvaluators;

import com.github.cafdataprocessing.corepolicy.common.ApiProperties;
import com.github.cafdataprocessing.corepolicy.common.EnvironmentSnapshot;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.Condition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.NumberCondition;
import com.github.cafdataprocessing.corepolicy.common.shared.MetadataValue;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.ConditionEvaluationResult;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.FieldConditionEvaluator;
import com.github.cafdataprocessing.corepolicy.document.DocumentUnderEvaluation;
import com.google.common.base.Strings;
import java.util.LinkedList;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="NumberCondition")
class NumberEvaluator
extends FieldConditionEvaluator<NumberCondition> {
    @Autowired
    public NumberEvaluator(ApiProperties apiProperties) {
        super(apiProperties);
    }

    @Override
    protected void evaluateFieldValues(ConditionEvaluationResult result, NumberCondition condition, DocumentUnderEvaluation document, EnvironmentSnapshot environmentSnapshot) {
        LinkedList<Long> documentFieldValues = new LinkedList<Long>();
        for (MetadataValue metadataValue : document.getValues(condition.field)) {
            String documentVal;
            if (metadataValue == null || Strings.isNullOrEmpty((String)(documentVal = metadataValue.getAsString()))) continue;
            try {
                documentFieldValues.add(Long.parseLong(documentVal));
            }
            catch (NumberFormatException ex) {}
        }
        switch (condition.operator) {
            case EQ: {
                result.setMatch(documentFieldValues.contains(condition.value));
                break;
            }
            case GT: {
                result.setMatch(documentFieldValues.stream().anyMatch(a -> numberCondition.value < a));
                break;
            }
            case LT: {
                result.setMatch(documentFieldValues.stream().anyMatch(a -> numberCondition.value > a));
                break;
            }
            default: {
                throw new NotImplementedException("Unrecognised number operator: " + condition.operator);
            }
        }
        result.populateEvaluationResult(result.isMatch(), (Condition)condition, document, false);
    }
}

