/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.conditionEvaluators;

import com.github.cafdataprocessing.corepolicy.common.ApiProperties;
import com.github.cafdataprocessing.corepolicy.common.EnvironmentSnapshot;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.Condition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.RegexCondition;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.ConditionEvaluationResult;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.ContentExpressionHelper;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.FieldConditionEvaluator;
import com.github.cafdataprocessing.corepolicy.document.DocumentUnderEvaluation;
import com.google.common.base.Stopwatch;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="RegexCondition")
public class RegexEvaluator
extends FieldConditionEvaluator<RegexCondition> {
    private ContentExpressionHelper contentExpressionHelper;

    @Autowired
    public RegexEvaluator(ContentExpressionHelper contentExpressionHelper, ApiProperties apiProperties) {
        super(apiProperties);
        this.contentExpressionHelper = contentExpressionHelper;
    }

    @Override
    protected void evaluateFieldValues(ConditionEvaluationResult result, RegexCondition condition, DocumentUnderEvaluation document, EnvironmentSnapshot environmentSnapshot) {
        String expression = condition.value;
        Stopwatch stopwatch = Stopwatch.createStarted();
        Collection<String> matches = this.contentExpressionHelper.handleRegexExpression(document, condition.field, expression);
        document.logTime("Evaluate-RegexCondition-Regex", stopwatch);
        result.populateEvaluationResult(!matches.isEmpty(), (Condition)condition, document, matches, true);
    }
}

