/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.conditionEvaluators;

import com.github.cafdataprocessing.corepolicy.common.EngineProperties;
import com.github.cafdataprocessing.corepolicy.common.exceptions.BackEndRequestFailedCpeException;
import com.github.cafdataprocessing.corepolicy.common.exceptions.CpeException;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.RegexMatcherFactory;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="singleton")
public class RegexMatcherFactoryImpl
implements RegexMatcherFactory {
    private static final Logger logger = LoggerFactory.getLogger(RegexMatcherFactoryImpl.class);
    private LoadingCache<String, Pattern> patternCache;

    @Autowired
    public RegexMatcherFactoryImpl(EngineProperties engineProperties) {
        Integer maxPatternCacheSize = 100000;
        Integer patternCacheExpiryHours = 24;
        try {
            maxPatternCacheSize = engineProperties.getRegexCacheMaxsize();
            patternCacheExpiryHours = engineProperties.getRegexCacheExpiryHours();
        }
        catch (Exception e) {
            logger.warn("Problem loading pattern cache settings from config, using default.", (Throwable)e);
        }
        this.patternCache = CacheBuilder.newBuilder().maximumSize((long)maxPatternCacheSize.intValue()).expireAfterAccess((long)patternCacheExpiryHours.intValue(), TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, Pattern>(){

            public Pattern load(String regexString) throws Exception {
                return Pattern.compile(regexString);
            }
        });
    }

    @Override
    public Pattern getPattern(String regexString) throws CpeException {
        try {
            return (Pattern)this.patternCache.get((Object)regexString);
        }
        catch (Exception ex) {
            throw new BackEndRequestFailedCpeException((Throwable)ex);
        }
    }
}

