/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.conditionEvaluators;

import com.github.cafdataprocessing.corepolicy.common.ApiProperties;
import com.github.cafdataprocessing.corepolicy.common.EnvironmentSnapshot;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.Condition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.StringCondition;
import com.github.cafdataprocessing.corepolicy.common.exceptions.BackEndRequestFailedCpeException;
import com.github.cafdataprocessing.corepolicy.common.exceptions.excpetionErrors.BackEndRequestFailedErrors;
import com.github.cafdataprocessing.corepolicy.common.shared.MetadataValue;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.ConditionEvaluationResult;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.FieldConditionEvaluator;
import com.github.cafdataprocessing.corepolicy.document.DocumentUnderEvaluation;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="StringCondition")
class StringEvaluator
extends FieldConditionEvaluator<StringCondition> {
    @Autowired
    public StringEvaluator(ApiProperties apiProperties) {
        super(apiProperties);
    }

    @Override
    protected void evaluateFieldValues(ConditionEvaluationResult result, StringCondition condition, DocumentUnderEvaluation document, EnvironmentSnapshot environmentSnapshot) {
        if (condition.field == null) {
            throw new BackEndRequestFailedCpeException(BackEndRequestFailedErrors.InvalidDataDetected, (Throwable)new IllegalArgumentException("A value is required for condition " + condition.id));
        }
        String fieldValue = condition.value.toUpperCase(Locale.getDefault());
        Collection<MetadataValue> fieldValues = document.getValues(condition.field);
        result.setMatch(this.isMatch(condition, fieldValue, fieldValues));
        result.populateEvaluationResult(result.isMatch(), (Condition)condition, document, Collections.singletonList(condition.value), false);
    }

    private boolean isMatch(StringCondition condition, String fieldValue, Collection<MetadataValue> metadataValues) {
        boolean match = false;
        Collection fieldValues = MetadataValue.getStringValues(metadataValues);
        switch (condition.operator) {
            case CONTAINS: {
                match = fieldValues.stream().anyMatch(value -> value.toUpperCase(Locale.getDefault()).contains(fieldValue));
                break;
            }
            case ENDS_WITH: {
                match = fieldValues.stream().anyMatch(value -> value.toUpperCase(Locale.getDefault()).endsWith(fieldValue));
                break;
            }
            case IS: {
                match = fieldValues.stream().anyMatch(value -> value.equalsIgnoreCase(fieldValue));
                break;
            }
            case STARTS_WITH: {
                match = fieldValues.stream().anyMatch(value -> value.toUpperCase(Locale.getDefault()).startsWith(fieldValue));
            }
        }
        return match;
    }
}

