/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.conditionEvaluators;

import com.github.cafdataprocessing.corepolicy.booleanagent.BooleanAgentQueryResult;
import com.github.cafdataprocessing.corepolicy.booleanagent.BooleanAgentServices;
import com.github.cafdataprocessing.corepolicy.common.ApiProperties;
import com.github.cafdataprocessing.corepolicy.common.EnvironmentSnapshot;
import com.github.cafdataprocessing.corepolicy.common.dto.UnevaluatedCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.Condition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.TextCondition;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.ConditionEvaluationResult;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.ContentExpressionHelper;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.FieldConditionEvaluator;
import com.github.cafdataprocessing.corepolicy.document.DocumentUnderEvaluation;
import com.google.common.base.Stopwatch;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="TextCondition")
class TextEvaluator
extends FieldConditionEvaluator<TextCondition> {
    private final BooleanAgentServices booleanAgentServices;
    private ContentExpressionHelper contentExpressionHelper;

    @Autowired
    public TextEvaluator(BooleanAgentServices booleanAgentServices, ContentExpressionHelper contentExpressionHelper, ApiProperties apiProperties) {
        super(apiProperties);
        this.booleanAgentServices = booleanAgentServices;
        this.contentExpressionHelper = contentExpressionHelper;
    }

    @Override
    protected void evaluateFieldValues(ConditionEvaluationResult result, TextCondition condition, DocumentUnderEvaluation document, EnvironmentSnapshot environmentSnapshot) {
        if (!this.booleanAgentServices.getAvailable()) {
            this.recordUnevaluatedCondition(result, (Condition)condition, UnevaluatedCondition.Reason.MISSING_SERVICE);
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        BooleanAgentQueryResult booleanAgentQueryResult = this.contentExpressionHelper.handleBooleanAgentExpression(environmentSnapshot.getInstanceId(), this.booleanAgentServices, document, condition.field, condition.language);
        document.logTime("Evaluate-TextCondition-Query", stopwatch);
        boolean isMatch = booleanAgentQueryResult != null && booleanAgentQueryResult.getConditionIdTerms().containsKey((Object)condition.id);
        result.populateEvaluationResult(isMatch, (Condition)condition, document, isMatch ? booleanAgentQueryResult.getConditionIdTerms().get((Object)condition.id) : null, true);
    }
}

