/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.document;

import com.github.cafdataprocessing.corepolicy.booleanagent.BooleanAgentQueryResult;
import com.github.cafdataprocessing.corepolicy.common.ApiProperties;
import com.github.cafdataprocessing.corepolicy.common.CaseInsensitiveKeyMultimap;
import com.github.cafdataprocessing.corepolicy.common.ConditionEngineMetadata;
import com.github.cafdataprocessing.corepolicy.common.Document;
import com.github.cafdataprocessing.corepolicy.common.LanguagesEnum;
import com.github.cafdataprocessing.corepolicy.common.ReferenceExtractor;
import com.github.cafdataprocessing.corepolicy.common.TimeUnitLogging;
import com.github.cafdataprocessing.corepolicy.common.dto.ConditionEngineResult;
import com.github.cafdataprocessing.corepolicy.common.dto.MatchedCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.UnmatchedCondition;
import com.github.cafdataprocessing.corepolicy.common.exceptions.BackEndRequestFailedCpeException;
import com.github.cafdataprocessing.corepolicy.common.shared.MetadataValue;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.CachedConditionEvaluationResult;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.ConditionEvaluationResult;
import com.github.cafdataprocessing.corepolicy.document.DocumentUnderEvaluation;
import com.github.cafdataprocessing.corepolicy.multimap.utils.CaseInsensitiveMultimap;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentUnderEvaluationImpl
implements DocumentUnderEvaluation {
    private static final Logger logger = LoggerFactory.getLogger(DocumentUnderEvaluationImpl.class);
    private Multimap<String, MetadataValue> labelValues = new CaseInsensitiveMultimap();
    private Multimap<String, MetadataValue> languageValues = new CaseInsensitiveMultimap();
    private Map<String, BooleanAgentQueryResult> fieldBooleanAgentQueryResults = new HashMap<String, BooleanAgentQueryResult>();
    private Collection<DocumentUnderEvaluation> documents = new ArrayList<DocumentUnderEvaluation>();
    private Boolean isExcluded = false;
    private Map<Long, MatchedCondition> matchedConditionEvaluationResults = new HashMap<Long, MatchedCondition>();
    private Map<Long, UnmatchedCondition> unmatchedConditionEvaluationResults = new HashMap<Long, UnmatchedCondition>();
    private HashSet<Long> conditionsEvaluatedThisRun = new HashSet();
    ConcurrentHashMap<String, Long> timings = new ConcurrentHashMap();
    private Multimap<String, MetadataValue> metadata = CaseInsensitiveMultimap.create();
    private Multimap<String, MetadataValue> streams = CaseInsensitiveKeyMultimap.create();
    private ConditionEngineMetadata conditionEngineMetadata;
    private ApiProperties apiProperties;

    public DocumentUnderEvaluationImpl(ConditionEngineMetadata conditionEngineMetadata, ApiProperties apiProperties) {
        this.conditionEngineMetadata = conditionEngineMetadata;
        this.apiProperties = apiProperties;
    }

    public DocumentUnderEvaluationImpl(Document document, ConditionEngineMetadata conditionEngineMetadata, ApiProperties apiProperties) {
        this(conditionEngineMetadata, apiProperties);
        for (Map.Entry entry : document.getMetadata().entries()) {
            this.metadata.put(entry.getKey(), (Object)new MetadataValue(apiProperties, (String)entry.getValue()));
        }
        for (Map.Entry entry : document.getStreams().entries()) {
            this.streams.put(entry.getKey(), (Object)new MetadataValue(apiProperties, (InputStream)entry.getValue()));
        }
        this.addMetadataString("CPE_CHILD_DOCUMENT_COUNT", String.valueOf(document.getDocuments().size()));
        int depth = this.getDepth();
        this.documents = document.getDocuments().stream().map(d -> {
            DocumentUnderEvaluationImpl documentUnderEvaluation = new DocumentUnderEvaluationImpl((Document)d, conditionEngineMetadata, apiProperties);
            documentUnderEvaluation.addMetadataString("CPE_CHILD_DOCUMENT_DEPTH", String.valueOf(depth + 1));
            return documentUnderEvaluation;
        }).collect(Collectors.toList());
        this.setupPreevaluatedInformation(document);
    }

    @Override
    public void addConditionEvaluationResult(ConditionEvaluationResult conditionEvaluationResult, Long conditionID) {
        if (conditionID == null) {
            logger.debug("addConditionEvaluationResult:: Warning - Mocked item has conditionID null.");
            return;
        }
        if (conditionEvaluationResult.isMatch()) {
            Optional<MatchedCondition> mc = conditionEvaluationResult.getMatchedConditions().stream().filter(u -> u.id != null && u.id.equals(conditionID)).findFirst();
            if (!mc.isPresent()) {
                throw new BackEndRequestFailedCpeException((Throwable)new RuntimeException("Unexpected exception - unable to get the conditionevaluation result, for an evaluated condition Id: " + conditionID));
            }
            this.matchedConditionEvaluationResults.put(conditionID, mc.get());
        } else {
            Optional<UnmatchedCondition> umc = conditionEvaluationResult.getUnmatchedConditions().stream().filter(u -> u.id != null && u.id.equals(conditionID)).findFirst();
            if (!umc.isPresent()) {
                return;
            }
            this.unmatchedConditionEvaluationResults.put(conditionID, umc.get());
        }
    }

    @Override
    public void addConditionEvaluationResult(MatchedCondition mc) {
        if (mc != null && mc.id != null) {
            this.matchedConditionEvaluationResults.put(mc.id, mc);
        }
    }

    @Override
    public void addConditionEvaluationResult(UnmatchedCondition umc) {
        if (umc != null && umc.id != null) {
            this.unmatchedConditionEvaluationResults.put(umc.id, umc);
        }
    }

    @Override
    public CachedConditionEvaluationResult getConditionEvaluationResult(Long conditionId) {
        CachedConditionEvaluationResult result = new CachedConditionEvaluationResult();
        if (this.matchedConditionEvaluationResults.containsKey(conditionId)) {
            result.setIsMatch(true);
            result.setMatchedCondition(this.matchedConditionEvaluationResults.get(conditionId));
            return result;
        }
        if (this.unmatchedConditionEvaluationResults.containsKey(conditionId)) {
            result.setIsMatch(false);
            result.setUnmatchedCondition(this.unmatchedConditionEvaluationResults.get(conditionId));
            return result;
        }
        return null;
    }

    @Override
    public void logTime(String category, Stopwatch stopwatch) {
        Stopwatch finalStopwatch = stopwatch.stop();
        this.timings.computeIfAbsent(category, key -> finalStopwatch.elapsed(TimeUnit.NANOSECONDS));
        this.timings.computeIfPresent(category, (key, value) -> value + finalStopwatch.elapsed(TimeUnit.NANOSECONDS));
    }

    @Override
    public void log(Logger logger) {
        StringBuilder logMessage = new StringBuilder();
        for (String key : this.timings.keySet().stream().sorted().collect(Collectors.toList())) {
            long nanos = this.timings.get(key);
            TimeUnitLogging.TimeUnitToString((StringBuilder)logMessage, (String)key, (long)nanos);
        }
        logger.debug(logMessage.toString());
    }

    @Override
    public Multimap<String, MetadataValue> getMetadata() {
        return this.metadata;
    }

    @Override
    public Multimap<String, MetadataValue> getStreams() {
        return this.streams;
    }

    @Override
    public Collection<DocumentUnderEvaluation> getDocuments() {
        return this.documents;
    }

    @Override
    public void addBooleanAgentQueryResult(String fieldName, LanguagesEnum language, BooleanAgentQueryResult booleanAgentQueryResult) {
        this.addBooleanAgentQueryResult(this.getFieldLanguageString(fieldName, language), booleanAgentQueryResult);
    }

    @Override
    public void addBooleanAgentQueryResult(String fieldName, BooleanAgentQueryResult booleanAgentQueryResult) {
        this.fieldBooleanAgentQueryResults.put(fieldName, booleanAgentQueryResult);
    }

    @Override
    public BooleanAgentQueryResult getBooleanAgentQueryResult(String fieldName, LanguagesEnum language) {
        return this.getBooleanAgentQueryResult(this.getFieldLanguageString(fieldName, language));
    }

    @Override
    public BooleanAgentQueryResult getBooleanAgentQueryResult(String fieldName) {
        return this.fieldBooleanAgentQueryResults.get(fieldName);
    }

    @Override
    public void addMetadataString(String key, String value) {
        this.metadata.put((Object)key, (Object)new MetadataValue(this.apiProperties, value));
    }

    @Override
    public void addMetadataStream(String key, InputStream value) {
        this.streams.put((Object)key, (Object)new MetadataValue(this.apiProperties, value));
    }

    @Override
    public boolean metadataContains(String key, String value) {
        return this.getMetadata().get((Object)key).stream().filter(u -> !Strings.isNullOrEmpty((String)u.getAsString()) && u.getAsString().contains(value)).findFirst().isPresent();
    }

    public void setDocuments(Collection<DocumentUnderEvaluation> documents) {
        this.documents = documents;
    }

    @Override
    public Integer getDepth() {
        if (this.metadata.containsKey((Object)"CPE_CHILD_DOCUMENT_DEPTH")) {
            return Integer.valueOf(((MetadataValue)this.metadata.get((Object)"CPE_CHILD_DOCUMENT_DEPTH").stream().findFirst().get()).getAsString());
        }
        return 0;
    }

    @Override
    public void addLabelValues(String labelName, Collection<MetadataValue> values) {
        this.labelValues.putAll((Object)labelName, values);
    }

    @Override
    public Collection<MetadataValue> getLabelValues(String labelName) {
        return this.labelValues.get((Object)labelName);
    }

    @Override
    public boolean hasLabelValues(String labelName) {
        return this.labelValues.containsKey((Object)labelName);
    }

    @Override
    public String getReference() {
        return ReferenceExtractor.getReferenceFromMap(this.metadata, (!this.documents.isEmpty() ? 1 : 0) != 0);
    }

    @Override
    public void setReference(String reference) {
        ReferenceExtractor.setReferenceAsMetadataValue(this.metadata, (String)reference, (ApiProperties)this.apiProperties);
    }

    @Override
    public boolean getFullMetadata() {
        if (this.metadata.containsKey((Object)"POLICY_KV_METADATA_PRESENT")) {
            return Boolean.valueOf(((MetadataValue)this.metadata.get((Object)"POLICY_KV_METADATA_PRESENT").stream().findFirst().get()).getAsString());
        }
        return true;
    }

    @Override
    public void setFullMetadata(boolean fullMetadata) {
        if (this.metadata.containsKey((Object)"POLICY_KV_METADATA_PRESENT")) {
            this.metadata.get((Object)"POLICY_KV_METADATA_PRESENT").clear();
        }
        this.addMetadataString("POLICY_KV_METADATA_PRESENT", String.valueOf(fullMetadata));
    }

    @Override
    public Boolean getIsExcluded() {
        return this.isExcluded;
    }

    @Override
    public void setIsExcluded(Boolean isExcluded) {
        this.isExcluded = isExcluded;
    }

    @Override
    public Collection<MetadataValue> getValues(String name) {
        if (this.labelValues.containsKey((Object)name)) {
            return this.getLabelValues(name);
        }
        if (this.getMetadata().containsKey((Object)name) || this.streams.containsKey((Object)name)) {
            Collection values = this.getMetadata().get((Object)name);
            if (this.streams.containsKey((Object)name)) {
                values.addAll(this.streams.get((Object)name));
            }
            return values;
        }
        return this.getMetadata().get((Object)name);
    }

    private String getCombinedFieldName(String fieldName, String dif) {
        if (dif == null) {
            return fieldName;
        }
        return fieldName + "-<" + dif + ">";
    }

    private String getFieldLanguageString(String fieldName, LanguagesEnum language) {
        return this.getCombinedFieldName(fieldName, language == null ? null : language.toString());
    }

    @Override
    public void addLanguageValue(String fieldName, LanguagesEnum language, MetadataValue value) {
        this.languageValues.put((Object)this.getFieldLanguageString(fieldName, language), (Object)value);
    }

    @Override
    public Collection<MetadataValue> getLanguageValue(String fieldName, LanguagesEnum language) {
        if (!this.languageValues.containsKey((Object)this.getFieldLanguageString(fieldName, language))) {
            return null;
        }
        return this.languageValues.get((Object)this.getFieldLanguageString(fieldName, language));
    }

    private void setupPreevaluatedInformation(Document document) {
        ConditionEngineResult result = this.conditionEngineMetadata.createResult(document.getMetadata());
        DocumentUnderEvaluationImpl.applyEvaluationInfo(result, this);
    }

    private static void applyEvaluationInfo(ConditionEngineResult previousResult, DocumentUnderEvaluation documentUnderEvaluation) {
        Collection<DocumentUnderEvaluation> documents = documentUnderEvaluation.getDocuments();
        for (DocumentUnderEvaluation childDocument : documents) {
            DocumentUnderEvaluationImpl.applyEvaluationInfo(previousResult, childDocument);
        }
        DocumentUnderEvaluationImpl.setupEvaluationInfoOnThisDocument(previousResult, documentUnderEvaluation);
    }

    private static void setupEvaluationInfoOnThisDocument(ConditionEngineResult previousResult, DocumentUnderEvaluation documentUnderEvaluation) {
        String docRef = documentUnderEvaluation.getReference();
        if (previousResult != null) {
            if (previousResult.matchedConditions.size() > 0) {
                for (MatchedCondition mc : previousResult.matchedConditions) {
                    if ((!Strings.isNullOrEmpty((String)docRef) || !Strings.isNullOrEmpty((String)mc.getReference())) && (Strings.isNullOrEmpty((String)docRef) || Strings.isNullOrEmpty((String)mc.getReference()) || !mc.getReference().equals(docRef))) continue;
                    documentUnderEvaluation.addConditionEvaluationResult(mc);
                }
            }
            if (previousResult.unmatchedConditions.size() > 0) {
                for (UnmatchedCondition umc : previousResult.unmatchedConditions) {
                    if ((!Strings.isNullOrEmpty((String)docRef) || !Strings.isNullOrEmpty((String)umc.getReference())) && (Strings.isNullOrEmpty((String)docRef) || Strings.isNullOrEmpty((String)umc.getReference()) || umc.getReference().equals(docRef))) continue;
                    documentUnderEvaluation.addConditionEvaluationResult(umc);
                }
            }
        }
    }

    @Override
    public void setConditionHasBeenEvaluatedThisRun(Long conditionId) {
        this.conditionsEvaluatedThisRun.add(conditionId);
    }

    @Override
    public Boolean hasConditionBeenEvaluatedThisRun(Long conditionId) {
        return this.conditionsEvaluatedThisRun.contains(conditionId);
    }
}

