/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.environment;

import com.github.cafdataprocessing.corepolicy.common.EnvironmentSnapshot;
import com.github.cafdataprocessing.corepolicy.common.domainModels.EnvironmentSnapshotImpl;
import com.github.cafdataprocessing.corepolicy.environment.EnvironmentInitializer;
import com.github.cafdataprocessing.corepolicy.environment.EnvironmentSnapshotApi;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

public class ApiInitializer
implements EnvironmentInitializer {
    private final EnvironmentSnapshotApi environmentSnapshotApi;

    @Autowired
    public ApiInitializer(EnvironmentSnapshotApi environmentSnapshotApi) {
        this.environmentSnapshotApi = environmentSnapshotApi;
    }

    @Override
    public EnvironmentSnapshotImpl initialize(EnvironmentSnapshotImpl environmentSnapshot) {
        EnvironmentSnapshot retrievedEnvironmentSnapshot;
        DateTime snapshotTime = null;
        DateTime csLastModifiedTime = null;
        if (environmentSnapshot.getCreateDate() != null) {
            snapshotTime = environmentSnapshot.getCreateDate();
        }
        if (environmentSnapshot.getCollectionSequenceLastModifiedDate() != null) {
            csLastModifiedTime = environmentSnapshot.getCollectionSequenceLastModifiedDate();
        }
        if ((retrievedEnvironmentSnapshot = this.environmentSnapshotApi.get(environmentSnapshot.getCollectionSequenceId(), snapshotTime, csLastModifiedTime)) == null) {
            return environmentSnapshot;
        }
        EnvironmentSnapshotImpl newEnvironmentSnapshot = new EnvironmentSnapshotImpl();
        newEnvironmentSnapshot.setCreateDate(retrievedEnvironmentSnapshot.getCreateDate());
        newEnvironmentSnapshot.setCollectionSequenceLastModifiedDate(retrievedEnvironmentSnapshot.getCollectionSequenceLastModifiedDate());
        newEnvironmentSnapshot.setCollectionSequenceId(retrievedEnvironmentSnapshot.getCollectionSequenceId());
        newEnvironmentSnapshot.setInstanceId(retrievedEnvironmentSnapshot.getInstanceId());
        newEnvironmentSnapshot.getCollections().putAll(retrievedEnvironmentSnapshot.getCollections());
        newEnvironmentSnapshot.getCollectionSequences().putAll(retrievedEnvironmentSnapshot.getCollectionSequences());
        newEnvironmentSnapshot.getConditions().putAll(retrievedEnvironmentSnapshot.getConditions());
        newEnvironmentSnapshot.getFieldLabels().putAll(retrievedEnvironmentSnapshot.getFieldLabels());
        newEnvironmentSnapshot.getLexicons().putAll(retrievedEnvironmentSnapshot.getLexicons());
        newEnvironmentSnapshot.getPolicies().putAll(retrievedEnvironmentSnapshot.getPolicies());
        newEnvironmentSnapshot.getPolicyTypes().putAll(retrievedEnvironmentSnapshot.getPolicyTypes());
        return newEnvironmentSnapshot;
    }

    @Override
    public EnvironmentSnapshotImpl remove(EnvironmentSnapshotImpl environmentSnapshot) {
        return environmentSnapshot;
    }
}

