/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.environment;

import com.github.cafdataprocessing.corepolicy.booleanagent.BooleanAgentServices;
import com.github.cafdataprocessing.corepolicy.booleanagent.ConditionToBooleanAgentConverter;
import com.github.cafdataprocessing.corepolicy.common.ElasticsearchProperties;
import com.github.cafdataprocessing.corepolicy.common.domainModels.EnvironmentSnapshotImpl;
import com.github.cafdataprocessing.corepolicy.common.dto.Lexicon;
import com.github.cafdataprocessing.corepolicy.common.dto.LexiconExpression;
import com.github.cafdataprocessing.corepolicy.common.dto.LexiconExpressionType;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.Condition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.TextCondition;
import com.github.cafdataprocessing.corepolicy.domainModels.BooleanAgentDocuments;
import com.github.cafdataprocessing.corepolicy.environment.EnvironmentInitializer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

public class BooleanAgentInitializer
implements EnvironmentInitializer {
    private final ElasticsearchProperties elasticsearchProperties;
    private final BooleanAgentServices booleanAgentServices;
    private final ConditionToBooleanAgentConverter conditionToBooleanAgentConverter;

    @Autowired
    public BooleanAgentInitializer(ElasticsearchProperties elasticsearchProperties, BooleanAgentServices booleanAgentServices, ConditionToBooleanAgentConverter conditionToBooleanAgentConverter) {
        this.elasticsearchProperties = elasticsearchProperties;
        this.booleanAgentServices = booleanAgentServices;
        this.conditionToBooleanAgentConverter = conditionToBooleanAgentConverter;
    }

    @Override
    public EnvironmentSnapshotImpl initialize(EnvironmentSnapshotImpl environmentSnapshot) {
        boolean agentsMightHaveExpired;
        if (!this.booleanAgentServices.getAvailable()) {
            return environmentSnapshot;
        }
        boolean bl = agentsMightHaveExpired = environmentSnapshot.getCreateDate().toDateTime().minusHours(1).getMillis() < DateTime.now().getMillis() - this.elasticsearchProperties.getAgentExpiry().toStandardDuration().getMillis();
        if (this.booleanAgentServices.existForInstanceId(environmentSnapshot.getInstanceId()) && !agentsMightHaveExpired) {
            return environmentSnapshot;
        }
        ArrayList<TextCondition> contentExpressionConditions = new ArrayList<TextCondition>();
        ArrayList<LexiconExpression> lexiconExpressions = new ArrayList<LexiconExpression>();
        LinkedList conditions = new LinkedList(environmentSnapshot.getConditions().values());
        for (Condition condition : conditions) {
            if (!(condition instanceof TextCondition)) continue;
            TextCondition contentExpressionCondition = (TextCondition)condition;
            contentExpressionConditions.add(contentExpressionCondition);
        }
        for (Lexicon lexiconToConvert : environmentSnapshot.getLexicons().values()) {
            lexiconExpressions.addAll(lexiconToConvert.lexiconExpressions.stream().filter(lexiconExpression -> lexiconExpression.type == LexiconExpressionType.TEXT).collect(Collectors.toList()));
        }
        BooleanAgentDocuments booleanAgentDocuments = this.conditionToBooleanAgentConverter.convert(contentExpressionConditions, lexiconExpressions);
        this.booleanAgentServices.create(environmentSnapshot.getInstanceId(), booleanAgentDocuments);
        return environmentSnapshot;
    }

    @Override
    public EnvironmentSnapshotImpl remove(EnvironmentSnapshotImpl environmentSnapshot) {
        return environmentSnapshot;
    }
}

