/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.environment;

import com.github.cafdataprocessing.corepolicy.common.EnvironmentSnapshot;
import com.github.cafdataprocessing.corepolicy.common.dto.CollectionSequence;
import com.github.cafdataprocessing.corepolicy.common.dto.CollectionSequenceEntry;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.BooleanCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.Condition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.DateCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.ExistsCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.FieldCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.FragmentCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.LexiconCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.NotCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.NumberCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.RegexCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.StringCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.TextCondition;
import com.github.cafdataprocessing.corepolicy.common.exceptions.BackEndRequestFailedCpeException;
import com.github.cafdataprocessing.corepolicy.common.exceptions.excpetionErrors.BackEndRequestFailedErrors;
import com.github.cafdataprocessing.corepolicy.common.shared.FingerprintGenerator;
import com.github.cafdataprocessing.corepolicy.common.shared.Sha1FingerprintGenerator;
import com.github.cafdataprocessing.corepolicy.environment.EnvironmentSnapshotFingerprintGenerator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionFingerprintGenerator {
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentSnapshotFingerprintGenerator.class);
    private EnvironmentSnapshot snapshot;
    private FingerprintGenerator fingerprintGenerator;

    ConditionFingerprintGenerator(EnvironmentSnapshot snapshot) {
        this.snapshot = snapshot;
        this.fingerprintGenerator = new Sha1FingerprintGenerator();
    }

    public static void populate(EnvironmentSnapshot snapshot) {
        ConditionFingerprintGenerator generator = new ConditionFingerprintGenerator(snapshot);
        generator.populateConditions();
    }

    private void populateConditions() {
        CollectionSequence sequence = (CollectionSequence)this.snapshot.getCollectionSequences().get(this.snapshot.getCollectionSequenceId());
        List entries = sequence.collectionSequenceEntries;
        if (entries != null) {
            for (CollectionSequenceEntry entry : entries) {
                for (Long collectionId : entry.collectionIds) {
                    Condition c = this.snapshot.getCollection((Long)collectionId).condition;
                    this.addFingerprint(c);
                }
            }
        }
        if (sequence.defaultCollectionId != null) {
            Condition c = this.snapshot.getCollection((Long)sequence.defaultCollectionId).condition;
            this.addFingerprint(c);
        }
    }

    void addFingerprint(Condition condition) {
        String fingerprintSource;
        if (condition == null) {
            return;
        }
        if (condition.fingerprint != null) {
            return;
        }
        switch (condition.conditionType) {
            case NUMBER: {
                fingerprintSource = this.getNumberFingerprintSource((NumberCondition)condition);
                break;
            }
            case NOT: {
                this.addFingerprint(((NotCondition)condition).condition);
                fingerprintSource = this.getNotFingerprintSource((NotCondition)condition);
                break;
            }
            case LEXICON: {
                fingerprintSource = this.getLexiconFingerprintSource((LexiconCondition)condition);
                break;
            }
            case EXISTS: {
                fingerprintSource = this.getExistsFingerprintSource((ExistsCondition)condition);
                break;
            }
            case DATE: {
                fingerprintSource = this.getDateFingerprintSource((DateCondition)condition);
                break;
            }
            case BOOLEAN: {
                for (Condition child : ((BooleanCondition)condition).children) {
                    this.addFingerprint(child);
                }
                fingerprintSource = this.getBooleanFingerprintSource((BooleanCondition)condition);
                break;
            }
            case TEXT: {
                fingerprintSource = this.getTextFingerprintSource((TextCondition)condition);
                break;
            }
            case REGEX: {
                fingerprintSource = this.getRegexFingerprintSource((RegexCondition)condition);
                break;
            }
            case STRING: {
                fingerprintSource = this.getStringFingerprintSource((StringCondition)condition);
                break;
            }
            case FRAGMENT: {
                this.addFingerprint(this.snapshot.getCondition(((FragmentCondition)condition).value));
                fingerprintSource = this.getFragmentFingerprintSource((FragmentCondition)condition);
                break;
            }
            default: {
                throw new RuntimeException("Unknown condition type detected!");
            }
        }
        condition.fingerprint = this.fingerprintGenerator.generate(fingerprintSource);
    }

    String getConditionFingerprintInput(Condition c) {
        StringBuilder sb = new StringBuilder();
        sb.append(c.id).append(c.name == null ? "" : c.name).append(c.conditionType);
        sb.append(c.isFragment).append(c.order).append(c.target).append(c.includeDescendants);
        return sb.toString();
    }

    String getFieldConditionFingerprintSource(FieldCondition condition) {
        StringBuilder fieldHashSource = new StringBuilder();
        if (this.snapshot.getFieldLabels().containsKey(condition.field)) {
            fieldHashSource.append(this.snapshot.getFieldLabel((String)condition.field).fingerprint);
        }
        fieldHashSource.append(condition.field);
        return this.getConditionFingerprintInput((Condition)condition) + fieldHashSource.toString();
    }

    String getNumberFingerprintSource(NumberCondition condition) {
        return this.getFieldConditionFingerprintSource((FieldCondition)condition) + condition.operator + condition.value;
    }

    String getNotFingerprintSource(NotCondition condition) {
        if (condition.condition == null) {
            return this.getConditionFingerprintInput((Condition)condition);
        }
        if (condition.condition.fingerprint == null) {
            throw new BackEndRequestFailedCpeException(BackEndRequestFailedErrors.InvalidDataDetected, (Throwable)new Exception("Not condition is missing child fingerprint."));
        }
        return this.getConditionFingerprintInput((Condition)condition) + condition.condition.fingerprint;
    }

    String getLexiconFingerprintSource(LexiconCondition condition) {
        String lexiconFp = this.snapshot.getLexicon((Long)condition.value).fingerprint;
        if (lexiconFp == null) {
            throw new BackEndRequestFailedCpeException(BackEndRequestFailedErrors.InvalidDataDetected, (Throwable)new Exception("Lexicon is missing fingerprint."));
        }
        return this.getFieldConditionFingerprintSource((FieldCondition)condition) + condition.language + lexiconFp;
    }

    String getExistsFingerprintSource(ExistsCondition condition) {
        return this.getFieldConditionFingerprintSource((FieldCondition)condition);
    }

    String getDateFingerprintSource(DateCondition condition) {
        return this.getFieldConditionFingerprintSource((FieldCondition)condition) + condition.value + condition.operator;
    }

    String getBooleanFingerprintSource(BooleanCondition condition) {
        StringBuilder sb = new StringBuilder(this.getConditionFingerprintInput((Condition)condition));
        sb.append(condition.operator);
        for (Condition c : condition.children) {
            if (c.fingerprint == null) {
                throw new BackEndRequestFailedCpeException(BackEndRequestFailedErrors.InvalidDataDetected, (Throwable)new Exception("Boolean condition is missing child fingerprint."));
            }
            sb.append(c.fingerprint);
        }
        return sb.toString();
    }

    String getTextFingerprintSource(TextCondition condition) {
        return this.getFieldConditionFingerprintSource((FieldCondition)condition) + condition.value;
    }

    String getRegexFingerprintSource(RegexCondition condition) {
        return this.getFieldConditionFingerprintSource((FieldCondition)condition) + condition.value;
    }

    String getStringFingerprintSource(StringCondition condition) {
        return this.getFieldConditionFingerprintSource((FieldCondition)condition) + condition.value + condition.operator;
    }

    String getFragmentFingerprintSource(FragmentCondition condition) {
        Condition childCondition = this.snapshot.getCondition(condition.value);
        if (childCondition.fingerprint == null) {
            throw new BackEndRequestFailedCpeException(BackEndRequestFailedErrors.InvalidDataDetected, (Throwable)new Exception("Fragment condition is missing fingerprint."));
        }
        return this.getConditionFingerprintInput((Condition)condition) + this.snapshot.getCondition((Long)condition.value).fingerprint;
    }
}

