/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.environment;

import com.github.cafdataprocessing.corepolicy.common.ClassificationApi;
import com.github.cafdataprocessing.corepolicy.common.EnvironmentSnapshot;
import com.github.cafdataprocessing.corepolicy.common.PolicyApi;
import com.github.cafdataprocessing.corepolicy.common.domainModels.EnvironmentSnapshotImpl;
import com.github.cafdataprocessing.corepolicy.common.dto.CollectionSequence;
import com.github.cafdataprocessing.corepolicy.common.dto.CollectionSequenceEntry;
import com.github.cafdataprocessing.corepolicy.common.dto.DocumentCollection;
import com.github.cafdataprocessing.corepolicy.common.dto.FieldLabel;
import com.github.cafdataprocessing.corepolicy.common.dto.Lexicon;
import com.github.cafdataprocessing.corepolicy.common.dto.Policy;
import com.github.cafdataprocessing.corepolicy.common.dto.PolicyType;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.BooleanCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.Condition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.FieldCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.FragmentCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.LexiconCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.NotCondition;
import com.github.cafdataprocessing.corepolicy.common.exceptions.BackEndRequestFailedCpeException;
import com.github.cafdataprocessing.corepolicy.common.exceptions.CpeException;
import com.github.cafdataprocessing.corepolicy.common.exceptions.excpetionErrors.BackEndRequestFailedErrors;
import com.github.cafdataprocessing.corepolicy.common.shared.CorePolicyLogger;
import com.github.cafdataprocessing.corepolicy.environment.EnvironmentSnapshotApi;
import com.github.cafdataprocessing.corepolicy.environment.EnvironmentSnapshotFingerprintGenerator;
import com.github.cafdataprocessing.corepolicy.repositories.EnvironmentSnapshotRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class EnvironmentSnapshotApiImpl
implements EnvironmentSnapshotApi {
    private final ClassificationApi classificationApi;
    private final PolicyApi policyApi;
    private final EnvironmentSnapshotRepository archiveApi;
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentSnapshotApiImpl.class);

    @Autowired
    public EnvironmentSnapshotApiImpl(ClassificationApi classificationApi, PolicyApi policyApi, EnvironmentSnapshotRepository archiveApi) {
        this.classificationApi = classificationApi;
        this.policyApi = policyApi;
        this.archiveApi = archiveApi;
        logger.trace("new EnvironmentSnapshotApiImpl");
    }

    @Override
    public EnvironmentSnapshot get(long collectionSequenceId, DateTime dateTime, DateTime csLastModifiedDateTime) {
        return this.initialize(collectionSequenceId, dateTime, csLastModifiedDateTime);
    }

    private void recordSnapshot(EnvironmentSnapshotImpl snapshot) {
        EnvironmentSnapshotFingerprintGenerator.populate(snapshot);
        this.archiveApi.recordSnapshot((EnvironmentSnapshot)snapshot);
    }

    private EnvironmentSnapshotImpl initialize(Long collectionSequenceId, DateTime dateTime, DateTime csLastModifiedDateTime) {
        try (CorePolicyLogger timingLogger = new CorePolicyLogger("EnvinromentSnapshotImpl::initialize");){
            logger.debug("initialize - Supplied previous snapshot collectionSequenceId: " + collectionSequenceId + " DateTime: " + dateTime + " CSLastModifiedTime: " + csLastModifiedDateTime);
            Optional optionalCollectionSequence = this.classificationApi.retrieveCollectionSequences(Arrays.asList(collectionSequenceId)).stream().findFirst();
            if (!optionalCollectionSequence.isPresent()) {
                throw new RuntimeException(String.format("Collection sequence %s does not exist.", collectionSequenceId));
            }
            CollectionSequence collectionSequence = (CollectionSequence)optionalCollectionSequence.get();
            logger.debug("initialize - CollectionSequence LastModified: " + collectionSequence.lastModified);
            if (csLastModifiedDateTime != null && collectionSequence.lastModified.getMillis() <= csLastModifiedDateTime.getMillis()) {
                logger.debug("initialize - No collection sequence changed detected");
                EnvironmentSnapshotImpl environmentSnapshotImpl = null;
                return environmentSnapshotImpl;
            }
            EnvironmentSnapshotImpl environmentSnapshot = new EnvironmentSnapshotImpl();
            environmentSnapshot.setCreateDate(DateTime.now((DateTimeZone)DateTimeZone.UTC));
            environmentSnapshot.setCollectionSequenceLastModifiedDate(collectionSequence.lastModified);
            environmentSnapshot.setCollectionSequenceId(collectionSequenceId);
            environmentSnapshot.getCollectionSequences().put(collectionSequence.id, collectionSequence);
            if (collectionSequence.defaultCollectionId != null) {
                this.addCollection(environmentSnapshot, collectionSequence.defaultCollectionId);
            }
            for (CollectionSequenceEntry collectionSequenceEntry : collectionSequence.collectionSequenceEntries) {
                this.addCollections(environmentSnapshot, collectionSequenceEntry);
            }
            Iterator labelIter = environmentSnapshot.getFieldLabels().entrySet().iterator();
            while (labelIter.hasNext()) {
                Map.Entry entry = labelIter.next();
                if (entry.getValue() != null) continue;
                labelIter.remove();
            }
            this.recordSnapshot(environmentSnapshot);
            EnvironmentSnapshotImpl environmentSnapshotImpl = environmentSnapshot;
            return environmentSnapshotImpl;
        }
    }

    private void addCollections(EnvironmentSnapshotImpl environmentSnapshot, CollectionSequenceEntry collectionSequenceEntry) {
        for (Long collectionId : collectionSequenceEntry.collectionIds) {
            this.addCollection(environmentSnapshot, collectionId);
        }
    }

    private void addCollection(EnvironmentSnapshotImpl environmentSnapshot, Long collectionId) throws CpeException {
        if (collectionId == null || environmentSnapshot.getCollections().containsKey(collectionId)) {
            return;
        }
        DocumentCollection documentCollection = (DocumentCollection)this.classificationApi.retrieveCollections(Arrays.asList(collectionId), true, true).stream().findFirst().get();
        if (documentCollection == null) {
            throw new BackEndRequestFailedCpeException(BackEndRequestFailedErrors.InvalidDataDetected, (Throwable)new Exception("Collection id " + collectionId + " does not exist."));
        }
        this.addCondition(environmentSnapshot, documentCollection.condition);
        if (documentCollection.policyIds != null) {
            documentCollection.policyIds.forEach(id -> this.addPolicy(environmentSnapshot, (Long)id));
        }
        environmentSnapshot.getCollections().put(documentCollection.id, documentCollection);
    }

    private void addCondition(EnvironmentSnapshotImpl environmentSnapshot, Condition condition) {
        if (condition == null || environmentSnapshot.getConditions().containsKey(condition.id)) {
            return;
        }
        environmentSnapshot.getConditions().put(condition.id, condition);
        if (condition instanceof FragmentCondition) {
            Collection retrieveConditions;
            FragmentCondition fragmentCondition = (FragmentCondition)condition;
            if (!environmentSnapshot.getConditions().containsKey(fragmentCondition.value) && (retrieveConditions = this.classificationApi.retrieveConditions(Arrays.asList(fragmentCondition.value), Boolean.valueOf(true))).size() > 0) {
                Condition retrievedCondition = (Condition)retrieveConditions.stream().findFirst().get();
                this.addCondition(environmentSnapshot, retrievedCondition);
            }
        } else if (condition instanceof NotCondition) {
            this.addCondition(environmentSnapshot, ((NotCondition)condition).condition);
        } else if (condition instanceof BooleanCondition) {
            for (Condition childCondition : ((BooleanCondition)condition).children) {
                this.addCondition(environmentSnapshot, childCondition);
            }
        } else if (condition instanceof LexiconCondition) {
            this.addLexicon(environmentSnapshot, ((LexiconCondition)condition).value);
        }
        if (condition instanceof FieldCondition) {
            String fieldName = ((FieldCondition)condition).field;
            this.addFieldLabel(environmentSnapshot, fieldName);
        }
    }

    private void addLexicon(EnvironmentSnapshotImpl environmentSnapshot, Long lexiconId) {
        if (environmentSnapshot.getLexicons().containsKey(lexiconId)) {
            return;
        }
        ArrayList<Long> lexiconIds = new ArrayList<Long>();
        lexiconIds.add(lexiconId);
        Lexicon lexicon = (Lexicon)this.classificationApi.retrieveLexicons(lexiconIds).stream().findFirst().get();
        environmentSnapshot.getLexicons().put(lexicon.id, lexicon);
    }

    private void addPolicy(EnvironmentSnapshotImpl environmentSnapshot, Long policyId) {
        if (environmentSnapshot.getPolicies().containsKey(policyId)) {
            return;
        }
        Policy policy = this.policyApi.retrievePolicy(policyId);
        this.addPolicyType(environmentSnapshot, policy.typeId);
        environmentSnapshot.getPolicies().put(policyId, policy);
    }

    private void addPolicyType(EnvironmentSnapshotImpl environmentSnapshot, Long policyTypeId) {
        if (environmentSnapshot.getPolicyTypes().containsKey(policyTypeId)) {
            return;
        }
        PolicyType policyType = this.policyApi.retrievePolicyType(policyTypeId);
        environmentSnapshot.getPolicyTypes().put(policyTypeId, policyType);
    }

    private void addFieldLabel(EnvironmentSnapshotImpl environmentSnapshot, String addFieldName) {
        if (environmentSnapshot.getFieldLabels().containsKey(addFieldName)) {
            return;
        }
        FieldLabel fieldLabel = this.classificationApi.retrieveFieldLabel(addFieldName);
        environmentSnapshot.getFieldLabels().put(addFieldName, fieldLabel);
    }
}

