/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.environment;

import com.github.cafdataprocessing.corepolicy.EnvironmentSnapshotCache;
import com.github.cafdataprocessing.corepolicy.common.EngineProperties;
import com.github.cafdataprocessing.corepolicy.common.EnvironmentSnapshot;
import com.github.cafdataprocessing.corepolicy.common.domainModels.EnvironmentSnapshotImpl;
import com.github.cafdataprocessing.corepolicy.common.exceptions.InvalidFieldValueCpeException;
import com.github.cafdataprocessing.corepolicy.common.exceptions.TransitoryBackEndFailureCpeException;
import com.github.cafdataprocessing.corepolicy.common.exceptions.excpetionErrors.BackEndRequestFailedErrors;
import com.github.cafdataprocessing.corepolicy.common.exceptions.excpetionErrors.InvalidFieldValueErrors;
import com.github.cafdataprocessing.corepolicy.common.shared.CorePolicyLogger;
import com.github.cafdataprocessing.corepolicy.environment.EnvironmentInitializer;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.TimeUnit;
import org.joda.time.Period;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class EnvironmentSnapshotCacheImpl
implements EnvironmentSnapshotCache {
    private LoadingCache<Long, EnvironmentSnapshot> conditionEngineRepositoryCache;
    private EnvironmentInitializer environmentInitializer;

    @Autowired
    public EnvironmentSnapshotCacheImpl(ApplicationContext applicationContext, EngineProperties engineProperties) {
        Integer maxSequenceCacheSize = engineProperties.getEnvironmentCacheMaxsize();
        Period period = new Period((Object)engineProperties.getEnvironmentCacheVerifyPeriod());
        this.environmentInitializer = (EnvironmentInitializer)applicationContext.getBean("Pipeline", EnvironmentInitializer.class);
        this.conditionEngineRepositoryCache = CacheBuilder.newBuilder().maximumSize((long)maxSequenceCacheSize.intValue()).expireAfterWrite(period.toStandardDuration().getMillis(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<Long, EnvironmentSnapshot>(){

            public EnvironmentSnapshot load(Long sequenceId) throws Exception {
                try (CorePolicyLogger traceInfo = new CorePolicyLogger("EnvironmentSnapshot:load");){
                    EnvironmentSnapshotImpl environmentSnapshot = new EnvironmentSnapshotImpl();
                    environmentSnapshot.setCollectionSequenceId(sequenceId);
                    EnvironmentSnapshotImpl environmentSnapshotImpl = environmentSnapshot = EnvironmentSnapshotCacheImpl.this.environmentInitializer.initialize(environmentSnapshot);
                    return environmentSnapshotImpl;
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EnvironmentSnapshot get(Long sequenceId) throws Exception {
        try (CorePolicyLogger traceInfo = new CorePolicyLogger("EnvironmentSnapshot:get");){
            EnvironmentSnapshot cachedEntry;
            EnvironmentSnapshot environmentSnapshot = cachedEntry = (EnvironmentSnapshot)this.conditionEngineRepositoryCache.get((Object)sequenceId);
            return environmentSnapshot;
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof TransitoryBackEndFailureCpeException) {
                BackEndRequestFailedErrors error = (BackEndRequestFailedErrors)((TransitoryBackEndFailureCpeException)e.getCause()).getError();
                throw new TransitoryBackEndFailureCpeException(error, (Throwable)e);
            }
            if (!(e.getCause() instanceof InvalidFieldValueCpeException)) throw e;
            InvalidFieldValueErrors error = (InvalidFieldValueErrors)((InvalidFieldValueCpeException)e.getCause()).getError();
            throw new InvalidFieldValueCpeException(error, (Throwable)e);
        }
    }

    @Override
    public void invalidate(Long sequenceId) {
        try (CorePolicyLogger traceInfo = new CorePolicyLogger("EnvironmentSnapshot:invalidate");){
            EnvironmentSnapshot cachedEntry = (EnvironmentSnapshot)this.conditionEngineRepositoryCache.getIfPresent((Object)sequenceId);
            if (cachedEntry != null && cachedEntry instanceof EnvironmentSnapshotImpl) {
                this.environmentInitializer.remove((EnvironmentSnapshotImpl)cachedEntry);
            }
            this.conditionEngineRepositoryCache.refresh((Object)sequenceId);
        }
    }
}

