/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.environment;

import com.github.cafdataprocessing.corepolicy.common.EnvironmentSnapshot;
import com.github.cafdataprocessing.corepolicy.common.domainModels.EnvironmentSnapshotImpl;
import com.github.cafdataprocessing.corepolicy.common.dto.CollectionSequence;
import com.github.cafdataprocessing.corepolicy.common.dto.CollectionSequenceEntry;
import com.github.cafdataprocessing.corepolicy.common.dto.DocumentCollection;
import com.github.cafdataprocessing.corepolicy.common.dto.FieldLabel;
import com.github.cafdataprocessing.corepolicy.common.dto.Lexicon;
import com.github.cafdataprocessing.corepolicy.common.dto.LexiconExpression;
import com.github.cafdataprocessing.corepolicy.common.dto.Policy;
import com.github.cafdataprocessing.corepolicy.common.shared.FingerprintGenerator;
import com.github.cafdataprocessing.corepolicy.common.shared.Sha1FingerprintGenerator;
import com.github.cafdataprocessing.corepolicy.environment.ConditionFingerprintGenerator;

public class EnvironmentSnapshotFingerprintGenerator {
    private EnvironmentSnapshotImpl snapshot;
    private FingerprintGenerator fingerprintGenerator;

    EnvironmentSnapshotFingerprintGenerator(EnvironmentSnapshotImpl snapshot) {
        this.snapshot = snapshot;
        this.fingerprintGenerator = new Sha1FingerprintGenerator();
    }

    public static void populate(EnvironmentSnapshotImpl snapshot) {
        EnvironmentSnapshotFingerprintGenerator generator = new EnvironmentSnapshotFingerprintGenerator(snapshot);
        generator.populateFingerprints();
    }

    private void populateFingerprints() {
        this.populateFieldLabels();
        this.populateLexicons();
        this.populateConditions();
        this.populatePolicies();
        this.populateCollections();
        this.populateCollectionSequences();
        if (this.snapshot.getCollectionSequences().size() != 1) {
            throw new RuntimeException("A snapshot can only be fingerprinted if it contains a single collection sequence.");
        }
        this.snapshot.fingerprint = ((CollectionSequence)this.snapshot.getCollectionSequences().get((Object)this.snapshot.getCollectionSequenceId())).fingerprint;
    }

    private void populatePolicies() {
        for (Policy p : this.snapshot.getPolicies().values()) {
            StringBuilder sb = new StringBuilder();
            sb.append(p.id).append(p.name).append(p.typeId).append(p.priority).append(p.details.textValue());
            p.fingerprint = this.fingerprintGenerator.generate(sb.toString());
        }
    }

    private void populateConditions() {
        ConditionFingerprintGenerator.populate((EnvironmentSnapshot)this.snapshot);
    }

    private void populateCollectionSequences() {
        for (CollectionSequence cs : this.snapshot.getCollectionSequences().values()) {
            StringBuilder sb = new StringBuilder();
            sb.append(cs.id).append(cs.name == null ? "" : cs.name).append(cs.defaultCollectionId).append(cs.excludedDocumentFragmentConditionId).append(cs.fullConditionEvaluation);
            for (CollectionSequenceEntry e : cs.collectionSequenceEntries) {
                sb.append("entry").append(e.order).append(e.stopOnMatch);
                for (Long id : e.collectionIds) {
                    sb.append(this.snapshot.getCollection((Long)id).fingerprint);
                }
            }
            cs.fingerprint = this.fingerprintGenerator.generate(sb.toString());
            for (CollectionSequenceEntry e : cs.collectionSequenceEntries) {
                StringBuilder entryBuilder = new StringBuilder();
                entryBuilder.append(cs.fingerprint).append(e.order).append(e.stopOnMatch);
                for (Long id : e.collectionIds) {
                    entryBuilder.append(this.snapshot.getCollection((Long)id).fingerprint);
                }
                e.fingerprint = this.fingerprintGenerator.generate(entryBuilder.toString());
            }
        }
    }

    private void populateCollections() {
        for (DocumentCollection c : this.snapshot.getCollections().values()) {
            StringBuilder sb = new StringBuilder();
            sb.append(c.id).append(c.name == null ? "" : c.name).append(c.condition == null ? "" : c.condition.fingerprint);
            for (Long policyId : c.policyIds) {
                sb.append(this.snapshot.getPolicy((Long)policyId).fingerprint);
            }
            c.fingerprint = this.fingerprintGenerator.generate(sb.toString());
        }
    }

    private void populateLexicons() {
        for (Lexicon l : this.snapshot.getLexicons().values()) {
            StringBuilder sb = new StringBuilder();
            sb.append(l.id).append(l.name == null ? "" : l.name);
            for (LexiconExpression le : l.lexiconExpressions) {
                StringBuilder sb2 = new StringBuilder();
                sb2.append(le.id).append(le.type).append(le.expression);
                le.fingerprint = this.fingerprintGenerator.generate(sb2.toString());
                sb.append(le.fingerprint);
            }
            l.fingerprint = this.fingerprintGenerator.generate(sb.toString());
        }
    }

    private void populateFieldLabels() {
        for (FieldLabel fl : this.snapshot.getFieldLabels().values()) {
            StringBuilder sb = new StringBuilder();
            sb.append(fl.id).append(fl.name == null ? "" : fl.name).append(fl.fieldType);
            fl.fingerprint = this.fingerprintGenerator.generate(sb.toString());
        }
    }
}

