/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.environment;

import com.github.cafdataprocessing.corepolicy.booleanagent.BooleanAgentServices;
import com.github.cafdataprocessing.corepolicy.common.EngineProperties;
import com.github.cafdataprocessing.corepolicy.common.domainModels.EnvironmentSnapshotImpl;
import com.github.cafdataprocessing.corepolicy.common.exceptions.CpeException;
import com.github.cafdataprocessing.corepolicy.common.shared.CorePolicyLogger;
import com.github.cafdataprocessing.corepolicy.common.shared.CorePolicyObjectMapper;
import com.github.cafdataprocessing.corepolicy.common.shared.Level;
import com.github.cafdataprocessing.corepolicy.environment.EnvironmentInitializer;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FilesystemInitializer
implements EnvironmentInitializer {
    private static final Logger logger = LoggerFactory.getLogger(FilesystemInitializer.class);
    private final BooleanAgentServices booleanAgentServices;
    private final CorePolicyObjectMapper objectMapper = new CorePolicyObjectMapper();
    private final Path environmentSnapshotCacheLocation;
    private final Period environmentCacheExpiry;

    @Autowired
    public FilesystemInitializer(EngineProperties engineProperties, BooleanAgentServices booleanAgentServices) {
        this.booleanAgentServices = booleanAgentServices;
        this.environmentSnapshotCacheLocation = Paths.get(engineProperties.getEnvironmentCacheLocation(), new String[0]);
        this.environmentCacheExpiry = engineProperties.getEnvironmentCacheExpiry();
    }

    @Override
    public EnvironmentSnapshotImpl initialize(EnvironmentSnapshotImpl environmentSnapshot) {
        try (CorePolicyLogger traceInfo = new CorePolicyLogger("FilesystemInitializer:initialize", Level.DEBUG);){
            EnvironmentSnapshotImpl environmentSnapshotImpl;
            this.removeReallyOldFiles();
            List<File> files = this.getFiles(environmentSnapshot.getCollectionSequenceId() + "-*.json");
            files = files.stream().sorted((p, o) -> Long.valueOf(o.lastModified()).compareTo(p.lastModified())).collect(Collectors.toList());
            if (files.isEmpty()) {
                traceInfo.log("No valid snapshot files left.");
                EnvironmentSnapshotImpl environmentSnapshotImpl2 = environmentSnapshot;
                return environmentSnapshotImpl2;
            }
            EnvironmentSnapshotImpl tmpSnapshot = null;
            File mostRecentFile = (File)files.stream().findFirst().get();
            for (File file : files) {
                if (file.equals(mostRecentFile) && !(tmpSnapshot = this.readFromFile(file)).getInvalidatedCache()) continue;
                this.checkExpireFile(file);
            }
            if (tmpSnapshot.getInvalidatedCache()) {
                traceInfo.log("Using new snapshot as tmpSnapshot has been invalidated.");
                environmentSnapshotImpl = environmentSnapshot;
                return environmentSnapshotImpl;
            }
            traceInfo.log("Using existing snapshot from disk: " + tmpSnapshot.getInstanceId() + " Persisted: " + tmpSnapshot.getPersistedDate());
            environmentSnapshotImpl = tmpSnapshot;
            return environmentSnapshotImpl;
        }
    }

    @Override
    public EnvironmentSnapshotImpl remove(EnvironmentSnapshotImpl environmentSnapshot) {
        return environmentSnapshot;
    }

    private List<File> getFiles(String pattern) {
        ArrayList<File> files = new ArrayList<File>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.environmentSnapshotCacheLocation, pattern);){
            for (Path entry : stream) {
                files.add(entry.toFile());
            }
        }
        catch (IOException x) {
            block33: {
                Throwable throwable = null;
                try (CorePolicyLogger traceInfo = new CorePolicyLogger("FilesystemInitializer:initialize", Level.DEBUG);){
                    traceInfo.log(String.format("error creating folder %s: %s", this.environmentSnapshotCacheLocation, x.getMessage()));
                    if (Files.exists(this.environmentSnapshotCacheLocation, new LinkOption[0])) break block33;
                    traceInfo.log(String.format("Environment snapshot cache location (%s) does not exist.", this.environmentSnapshotCacheLocation));
                    try {
                        Files.createDirectories(this.environmentSnapshotCacheLocation.toAbsolutePath(), new FileAttribute[0]);
                        ArrayList<File> entry = files;
                        return entry;
                    }
                    catch (IOException ex) {
                        try {
                            traceInfo.log(String.format("error creating folder %s: %s", this.environmentSnapshotCacheLocation, ex.getMessage()));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                    }
                }
            }
            throw new RuntimeException(String.format("error reading folder %s: %s", this.environmentSnapshotCacheLocation, x.getMessage()), x);
        }
        return files;
    }

    private void removeReallyOldFiles() {
        List<File> files = this.getFiles("*-*.json");
        for (File file : files) {
            this.checkExpireFile(file);
        }
    }

    private void checkExpireFile(File file) {
        try {
            BasicFileAttributes basicAttr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            if (basicAttr.creationTime().toMillis() < new DateTime().minus((ReadablePeriod)this.environmentCacheExpiry).getMillis()) {
                this.cleanupOldFile(file);
            }
        }
        catch (IOException e) {
            logger.warn(String.format("Could not access %s to evaluate for expiry.", file.toURI()));
        }
    }

    private void cleanupOldFile(File file) {
        boolean deleted;
        String filename = file.getName();
        String instanceId = filename.substring(filename.indexOf("-") + 1, filename.indexOf("."));
        if (this.booleanAgentServices.getAvailable()) {
            try {
                this.booleanAgentServices.delete(instanceId);
            }
            catch (CpeException e) {
                logger.warn("Unable to delete BooleanAgentServices for instance: " + instanceId);
            }
        }
        if (!(deleted = file.delete())) {
            logger.warn("Could not expire " + file.getAbsolutePath());
        }
    }

    EnvironmentSnapshotImpl readFromFile(File file) {
        try {
            EnvironmentSnapshotImpl environmentSnapshotFromDisk = (EnvironmentSnapshotImpl)this.objectMapper.readValue(file, EnvironmentSnapshotImpl.class);
            return environmentSnapshotFromDisk;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

