/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.environment;

import com.github.cafdataprocessing.corepolicy.common.EngineProperties;
import com.github.cafdataprocessing.corepolicy.common.domainModels.EnvironmentSnapshotImpl;
import com.github.cafdataprocessing.corepolicy.common.shared.CorePolicyLogger;
import com.github.cafdataprocessing.corepolicy.common.shared.CorePolicyObjectMapper;
import com.github.cafdataprocessing.corepolicy.common.shared.Level;
import com.github.cafdataprocessing.corepolicy.environment.EnvironmentInitializer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Autowired;

public class FilesystemPersistence
implements EnvironmentInitializer {
    private final EngineProperties engineProperties;
    CorePolicyObjectMapper objectMapper = new CorePolicyObjectMapper();

    @Autowired
    public FilesystemPersistence(EngineProperties engineProperties) {
        this.engineProperties = engineProperties;
    }

    @Override
    public EnvironmentSnapshotImpl initialize(EnvironmentSnapshotImpl environmentSnapshot) {
        try (CorePolicyLogger traceLogger = new CorePolicyLogger("FileSystemPersisence:initialize", Level.DEBUG);){
            if (environmentSnapshot.getPersistedDate() != null) {
                traceLogger.log("snapshot has already been persisted - nothing to do.");
                EnvironmentSnapshotImpl environmentSnapshotImpl = environmentSnapshot;
                return environmentSnapshotImpl;
            }
            environmentSnapshot.setPersistedDate(DateTime.now((DateTimeZone)DateTimeZone.UTC));
            String filename = String.valueOf(environmentSnapshot.getCollectionSequenceId()) + "-" + environmentSnapshot.getInstanceId() + ".json";
            Path cacheFilePath = Paths.get(this.engineProperties.getEnvironmentCacheLocation(), filename);
            File file = cacheFilePath.toFile();
            traceLogger.log("Persisting as: " + cacheFilePath);
            try {
                this.objectMapper.writeValue(file, (Object)environmentSnapshot);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            EnvironmentSnapshotImpl environmentSnapshotImpl = environmentSnapshot;
            return environmentSnapshotImpl;
        }
    }

    @Override
    public EnvironmentSnapshotImpl remove(EnvironmentSnapshotImpl environmentSnapshot) {
        try (CorePolicyLogger traceLogger = new CorePolicyLogger("FileSystemPersisence:remove", Level.DEBUG);){
            if (environmentSnapshot.getPersistedDate() == null) {
                traceLogger.log("No persisted date - nothing to do.");
                EnvironmentSnapshotImpl environmentSnapshotImpl = environmentSnapshot;
                return environmentSnapshotImpl;
            }
            if (environmentSnapshot.getInvalidatedCache()) {
                traceLogger.log("Cache already invalidated - nothing to do.");
                EnvironmentSnapshotImpl environmentSnapshotImpl = environmentSnapshot;
                return environmentSnapshotImpl;
            }
            String filename = String.valueOf(environmentSnapshot.getCollectionSequenceId()) + "-" + environmentSnapshot.getInstanceId() + ".json";
            Path cacheFilePath = Paths.get(this.engineProperties.getEnvironmentCacheLocation(), filename);
            File file = cacheFilePath.toFile();
            environmentSnapshot.setInvalidatedCache(true);
            traceLogger.log("Updating persisted item with invalidated marker - location: " + cacheFilePath);
            try {
                this.objectMapper.writeValue(file, (Object)environmentSnapshot);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            EnvironmentSnapshotImpl environmentSnapshotImpl = environmentSnapshot;
            return environmentSnapshotImpl;
        }
    }
}

