/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.environment;

import com.github.cafdataprocessing.corepolicy.common.domainModels.EnvironmentSnapshotImpl;
import com.github.cafdataprocessing.corepolicy.common.shared.CorePolicyLogger;
import com.github.cafdataprocessing.corepolicy.common.shared.Level;
import com.github.cafdataprocessing.corepolicy.environment.ApiInitializer;
import com.github.cafdataprocessing.corepolicy.environment.BooleanAgentInitializer;
import com.github.cafdataprocessing.corepolicy.environment.EnvironmentInitializer;
import com.github.cafdataprocessing.corepolicy.environment.FilesystemInitializer;
import com.github.cafdataprocessing.corepolicy.environment.FilesystemPersistence;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;

public class InitializationPipelineImpl
implements EnvironmentInitializer {
    private Collection<EnvironmentInitializer> stages;

    @Autowired
    public InitializationPipelineImpl(FilesystemInitializer filesystemInitializer, ApiInitializer apiInitializer, FilesystemPersistence filesystemPersistence, BooleanAgentInitializer booleanAgentInitializer) {
        this.stages = Arrays.asList(filesystemInitializer, apiInitializer, filesystemPersistence, booleanAgentInitializer);
    }

    @Override
    public EnvironmentSnapshotImpl initialize(EnvironmentSnapshotImpl environmentSnapshot) {
        try (CorePolicyLogger traceInfo = new CorePolicyLogger("InitializationPipelineImpl:initialize", Level.DEBUG);){
            for (EnvironmentInitializer environmentInitializer : this.stages) {
                environmentSnapshot = environmentInitializer.initialize(environmentSnapshot);
            }
            EnvironmentSnapshotImpl environmentSnapshotImpl = environmentSnapshot;
            return environmentSnapshotImpl;
        }
    }

    @Override
    public EnvironmentSnapshotImpl remove(EnvironmentSnapshotImpl environmentSnapshot) {
        try (CorePolicyLogger traceInfo = new CorePolicyLogger("InitializationPipelineImpl:remove", Level.DEBUG);){
            for (EnvironmentInitializer environmentInitializer : this.stages) {
                environmentSnapshot = environmentInitializer.remove(environmentSnapshot);
            }
            EnvironmentSnapshotImpl environmentSnapshotImpl = environmentSnapshot;
            return environmentSnapshotImpl;
        }
    }
}

