/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.policy.MetadataPolicy;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.cafdataprocessing.corepolicy.common.PolicyApi;
import com.github.cafdataprocessing.corepolicy.common.dto.Policy;
import com.github.cafdataprocessing.corepolicy.common.dto.PolicyType;
import com.github.cafdataprocessing.corepolicy.policy.MetadataPolicy.MetadataPolicy;
import com.github.cafdataprocessing.corepolicy.policy.MetadataPolicy.MetadataPolicyConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="MetadataPolicy_Converter")
public class MetadataPolicyConverterImpl
implements MetadataPolicyConverter {
    private static final Logger logger = LoggerFactory.getLogger(MetadataPolicyConverterImpl.class);
    private final PolicyApi policyApi;
    private PolicyType policyType;

    @Autowired
    public MetadataPolicyConverterImpl(PolicyApi policyApi) {
        this.policyApi = policyApi;
    }

    @Override
    public MetadataPolicy convert(Policy policy) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        this.validate(policy);
        MetadataPolicy metadataPolicy = (MetadataPolicy)objectMapper.treeToValue((TreeNode)policy.details, MetadataPolicy.class);
        return metadataPolicy;
    }

    @Override
    public void validate(Policy policy) throws Exception {
        if (this.policyType == null) {
            this.policyType = this.policyApi.retrievePolicyType(policy.typeId);
        }
        this.policyApi.validate(policy, this.policyType);
    }
}

