/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.policy.MetadataPolicy;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.cafdataprocessing.corepolicy.PolicyHandler;
import com.github.cafdataprocessing.corepolicy.ProcessingAction;
import com.github.cafdataprocessing.corepolicy.common.Document;
import com.github.cafdataprocessing.corepolicy.common.dto.Policy;
import com.github.cafdataprocessing.corepolicy.common.exceptions.BackEndRequestFailedCpeException;
import com.github.cafdataprocessing.corepolicy.domainModels.FieldAction;
import com.github.cafdataprocessing.corepolicy.policy.MetadataPolicy.MetadataPolicy;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;

public class MetadataPolicyHandler
implements PolicyHandler {
    private final long metadataPolicyTypeId;

    public MetadataPolicyHandler(long metadataPolicyTypeId) {
        this.metadataPolicyTypeId = metadataPolicyTypeId;
    }

    @Override
    public long getPolicyTypeId() {
        return this.metadataPolicyTypeId;
    }

    @Override
    public Collection<Policy> resolve(Document document, Collection<Policy> policies) {
        if (policies == null || policies.isEmpty()) {
            return new HashSet<Policy>();
        }
        if (!policies.stream().allMatch(u -> ((Policy)collection.stream().findFirst().get()).typeId.equals(u.typeId))) {
            throw new BackEndRequestFailedCpeException((Throwable)new Exception("The policies are not of the same type"));
        }
        return (Collection)((Map.Entry)policies.stream().collect(Collectors.groupingBy(u -> u.priority)).entrySet().stream().max((x, y) -> Long.compare(((Integer)x.getKey()).intValue(), ((Integer)y.getKey()).intValue())).get()).getValue();
    }

    @Override
    public ProcessingAction handle(Document document, Policy policy, Long collectionSequenceId) {
        MetadataPolicy metadataPolicy = this.getMetadataPolicy(policy);
        Collection<FieldAction> fieldActions = metadataPolicy.getFieldActions();
        this.applyFieldActions(document, fieldActions);
        return ProcessingAction.CONTINUE_PROCESSING;
    }

    private MetadataPolicy getMetadataPolicy(Policy policy) {
        MetadataPolicy metadataPolicy;
        try {
            ObjectMapper mapper = new ObjectMapper();
            metadataPolicy = (MetadataPolicy)mapper.treeToValue((TreeNode)policy.details, MetadataPolicy.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return metadataPolicy;
    }

    private void applyFieldActions(Document document, Collection<FieldAction> fieldActions) {
        for (FieldAction fieldAction : fieldActions) {
            FieldAction.Action action = fieldAction.getAction();
            if (action == FieldAction.Action.SET_FIELD_VALUE) {
                document.getMetadata().get((Object)fieldAction.getFieldName()).clear();
                document.getMetadata().put((Object)fieldAction.getFieldName(), (Object)fieldAction.getFieldValue());
                continue;
            }
            if (action != FieldAction.Action.ADD_FIELD_VALUE) continue;
            document.getMetadata().put((Object)fieldAction.getFieldName(), (Object)fieldAction.getFieldValue());
        }
    }
}

