/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.policy.TagPolicy;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.cafdataprocessing.corepolicy.common.PolicyApi;
import com.github.cafdataprocessing.corepolicy.common.dto.Policy;
import com.github.cafdataprocessing.corepolicy.common.dto.PolicyType;
import com.github.cafdataprocessing.corepolicy.policy.TagPolicy.TagPolicy;
import com.github.cafdataprocessing.corepolicy.policy.TagPolicy.TagPolicyConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="TagPolicy_Converter")
public class TagPolicyConvertorImpl
implements TagPolicyConverter {
    private static final Logger logger = LoggerFactory.getLogger(TagPolicyConvertorImpl.class);
    private final PolicyApi policyApi;
    private PolicyType policyType;

    @Autowired
    public TagPolicyConvertorImpl(PolicyApi policyApi) {
        this.policyApi = policyApi;
    }

    @Override
    public TagPolicy convert(Policy policy) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        this.validate(policy);
        TagPolicy policy1 = (TagPolicy)objectMapper.treeToValue((TreeNode)policy.details, TagPolicy.class);
        return policy1;
    }

    @Override
    public void validate(Policy policy) throws Exception {
        if (this.policyType == null) {
            this.policyType = this.policyApi.retrievePolicyType(policy.typeId);
        }
        this.policyApi.validate(policy, this.policyType);
    }
}

