/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.validation;

import com.github.cafdataprocessing.corepolicy.booleanagent.BooleanAgentServices;
import com.github.cafdataprocessing.corepolicy.validation.ValidationResult;
import com.github.cafdataprocessing.corepolicy.validation.Validator;
import com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="AgentExpressionValidator")
public class AgentExpressionValidator
implements Validator<String> {
    private static final int MAX_THREE_BYTE_CODEPOINT = Integer.parseInt("FFFF", 16);
    private static final Logger logger = LoggerFactory.getLogger(AgentExpressionValidator.class);
    private final BooleanAgentServices booleanAgentServices;

    @Autowired
    public AgentExpressionValidator(BooleanAgentServices booleanAgentServices) {
        this.booleanAgentServices = booleanAgentServices;
    }

    @Override
    public ValidationResult validate(String stringToValidate) {
        if (Strings.isNullOrEmpty((String)stringToValidate)) {
            return new ValidationResult("Content expression cannot be empty.");
        }
        for (int i = 0; i < stringToValidate.length(); ++i) {
            int codepoint = stringToValidate.codePointAt(i);
            if (codepoint <= MAX_THREE_BYTE_CODEPOINT) continue;
            return new ValidationResult("Agent expression invalid - codepoint " + codepoint + " is greater than max allowed " + MAX_THREE_BYTE_CODEPOINT + ".");
        }
        if (!this.booleanAgentServices.getAvailable()) {
            throw new RuntimeException("Agent service is not available to validate expressions.");
        }
        try {
            this.booleanAgentServices.isValidExpression(stringToValidate);
        }
        catch (Exception e) {
            logger.error("Error testing agent expression using documentstats :" + stringToValidate, (Throwable)e);
            return new ValidationResult("Content expression '" + stringToValidate + "' is not valid.");
        }
        return new ValidationResult();
    }
}

