/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.validation;

import com.github.cafdataprocessing.corepolicy.validation.ValidationResult;
import com.github.cafdataprocessing.corepolicy.validation.Validator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ValidatorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Primary
@Component
public class ObjectValidator<Object>
implements Validator<Object> {
    private ValidatorFactory validatorFactory;

    @Autowired
    public ObjectValidator(ValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    @Override
    public ValidationResult validate(Object objectToValidate) {
        Set validate = this.validatorFactory.getValidator().validate(objectToValidate, new Class[0]);
        if (validate != null && validate.size() > 0) {
            return new ValidationResult(validate.stream().map(ConstraintViolation::getMessage).distinct().collect(Collectors.joining("\n")));
        }
        return new ValidationResult();
    }
}

