/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.validation;

import com.github.cafdataprocessing.corepolicy.validation.ValidationResult;
import com.github.cafdataprocessing.corepolicy.validation.Validator;
import com.google.common.base.Strings;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.springframework.stereotype.Component;

@Component(value="RegexValidator")
public class RegexValidator
implements Validator<String> {
    @Override
    public ValidationResult validate(String regexString) {
        if (Strings.isNullOrEmpty((String)regexString)) {
            return new ValidationResult("Regex must have a value.");
        }
        try {
            Pattern.compile(regexString);
        }
        catch (PatternSyntaxException e) {
            return new ValidationResult("Regex was invalid. " + e.getMessage());
        }
        return new ValidationResult();
    }
}

