/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.validation.validators;

import com.github.cafdataprocessing.corepolicy.common.dto.LexiconExpression;
import com.github.cafdataprocessing.corepolicy.validation.AgentExpressionValidator;
import com.github.cafdataprocessing.corepolicy.validation.RegexValidator;
import com.github.cafdataprocessing.corepolicy.validation.ValidationResult;
import com.github.cafdataprocessing.corepolicy.validation.validators.CheckLexiconExpressionValue;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CheckLexiconExpressionValueValidator
implements ConstraintValidator<CheckLexiconExpressionValue, LexiconExpression> {
    private AgentExpressionValidator agentExpressionValidator;
    private RegexValidator regexValidator;

    @Autowired
    public CheckLexiconExpressionValueValidator(AgentExpressionValidator agentExpressionValidator, RegexValidator regexValidator) {
        this.agentExpressionValidator = agentExpressionValidator;
        this.regexValidator = regexValidator;
    }

    public void initialize(CheckLexiconExpressionValue constraintAnnotation) {
    }

    public boolean isValid(LexiconExpression value, ConstraintValidatorContext context) {
        if (value.type == null) {
            return false;
        }
        ValidationResult validationResult = null;
        switch (value.type) {
            case REGEX: {
                validationResult = this.regexValidator.validate(value.expression);
                break;
            }
            case TEXT: {
                validationResult = this.agentExpressionValidator.validate(value.expression);
            }
        }
        return validationResult != null && validationResult.isValid();
    }
}

