/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.worker.ingestion;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.hpe.caf.worker.document.DocumentWorkerDocument;
import com.hpe.caf.worker.document.DocumentWorkerFailure;
import com.hpe.caf.worker.document.DocumentWorkerFieldValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;

public class DocumentWorkerDocumentDeserializer
extends StdDeserializer<DocumentWorkerDocument> {
    private final int totalSubdocumentLimit;

    public DocumentWorkerDocumentDeserializer(int totalSubdocumentLimit) {
        this(null, totalSubdocumentLimit);
    }

    public DocumentWorkerDocumentDeserializer(Class<?> vc, int totalSubdocumentLimit) {
        super(vc);
        this.totalSubdocumentLimit = totalSubdocumentLimit;
    }

    public DocumentWorkerDocument deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        MutableInt totalSubdocuments = new MutableInt();
        DocumentWorkerDocument documentWorkerDocument = this.deserializeDocumentWorkerDocument(jsonParser, deserializationContext, totalSubdocuments);
        if (totalSubdocuments.intValue() > this.totalSubdocumentLimit) {
            if (documentWorkerDocument.failures == null) {
                documentWorkerDocument.failures = new ArrayList();
            }
            DocumentWorkerFailure subdocumentsTruncatedFailure = new DocumentWorkerFailure();
            subdocumentsTruncatedFailure.failureId = "IBWP-SUBDOCUMENTS_TRUNCATED-WARNING";
            subdocumentsTruncatedFailure.failureMessage = String.format("Subdocuments were truncated at %s", this.totalSubdocumentLimit);
            subdocumentsTruncatedFailure.failureStack = Arrays.toString(Thread.currentThread().getStackTrace());
            documentWorkerDocument.failures.add(subdocumentsTruncatedFailure);
        }
        return documentWorkerDocument;
    }

    private DocumentWorkerDocument deserializeDocumentWorkerDocument(JsonParser jsonParser, DeserializationContext deserializationContext, MutableInt totalSubdocuments) throws IOException {
        if (jsonParser.currentToken() != JsonToken.START_OBJECT) {
            throw new IllegalStateException(String.format("Expected '{' at %s", jsonParser.getCurrentLocation().toString()));
        }
        DocumentWorkerDocument documentWorkerDocument = new DocumentWorkerDocument();
        jsonParser.nextToken();
        while (jsonParser.currentToken() != JsonToken.END_OBJECT) {
            if (jsonParser.currentToken() != JsonToken.FIELD_NAME) {
                throw new IllegalStateException(String.format("Expected 'Field' at %s", jsonParser.getCurrentLocation().toString()));
            }
            String field = jsonParser.getCurrentName();
            jsonParser.nextToken();
            switch (field) {
                case "reference": {
                    documentWorkerDocument.reference = jsonParser.getValueAsString();
                    break;
                }
                case "fields": {
                    documentWorkerDocument.fields = (Map)deserializationContext.readValue(jsonParser, deserializationContext.getTypeFactory().constructType((TypeReference)new TypeReference<Map<String, List<DocumentWorkerFieldValue>>>(){}));
                    break;
                }
                case "failures": {
                    documentWorkerDocument.failures = (List)deserializationContext.readValue(jsonParser, deserializationContext.getTypeFactory().constructType((TypeReference)new TypeReference<List<DocumentWorkerFailure>>(){}));
                    break;
                }
                case "subdocuments": {
                    documentWorkerDocument.subdocuments = this.deserializeSubdocuments(jsonParser, deserializationContext, totalSubdocuments);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Unexpected field '%s' at %s", field, jsonParser.getCurrentLocation().toString()));
                }
            }
            jsonParser.nextToken();
        }
        return documentWorkerDocument;
    }

    private List<DocumentWorkerDocument> deserializeSubdocuments(JsonParser jsonParser, DeserializationContext deserializationContext, MutableInt totalSubdocuments) throws IOException {
        if (jsonParser.currentToken() != JsonToken.START_ARRAY) {
            throw new IllegalStateException(String.format("Expected '[' at %s", jsonParser.getCurrentLocation().toString()));
        }
        jsonParser.nextToken();
        ArrayList<DocumentWorkerDocument> documentWorkerSubdocumentList = new ArrayList<DocumentWorkerDocument>();
        while (jsonParser.currentToken() != JsonToken.END_ARRAY) {
            totalSubdocuments.increment();
            if (totalSubdocuments.intValue() <= this.totalSubdocumentLimit) {
                documentWorkerSubdocumentList.add(this.deserializeDocumentWorkerDocument(jsonParser, deserializationContext, totalSubdocuments));
            } else {
                jsonParser.skipChildren();
            }
            jsonParser.nextToken();
        }
        return documentWorkerSubdocumentList;
    }
}

