/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.worker.ingestion;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.github.cafdataprocessing.services.staging.BatchId;
import com.github.cafdataprocessing.services.staging.TenantId;
import com.github.cafdataprocessing.services.staging.dao.filesystem.BatchPathProvider;
import com.github.cafdataprocessing.services.staging.exceptions.InvalidBatchIdException;
import com.github.cafdataprocessing.services.staging.exceptions.InvalidTenantIdException;
import com.github.cafdataprocessing.worker.ingestion.DocumentWorkerDocumentDeserializer;
import com.github.cafdataprocessing.worker.ingestion.models.Subbatch;
import com.github.cafdataprocessing.worker.ingestion.validator.FieldValidator;
import com.github.cafdataprocessing.worker.ingestion.validator.FieldValidatorInterface;
import com.github.cafdataprocessing.worker.ingestion.validator.NullFieldValidator;
import com.hpe.caf.worker.batch.BatchDefinitionException;
import com.hpe.caf.worker.batch.BatchWorkerPlugin;
import com.hpe.caf.worker.batch.BatchWorkerServices;
import com.hpe.caf.worker.batch.BatchWorkerTransientException;
import com.hpe.caf.worker.document.DocumentWorkerDocument;
import com.hpe.caf.worker.document.DocumentWorkerDocumentTask;
import com.hpe.caf.worker.document.DocumentWorkerScript;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.AccessMode;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IngestionBatchWorkerPlugin
implements BatchWorkerPlugin {
    private static final Logger log = LoggerFactory.getLogger(IngestionBatchWorkerPlugin.class);
    private final ObjectMapper mapper;
    private final BatchPathProvider fileSystemProvider;
    private final FieldValidatorInterface fieldValidator;

    public IngestionBatchWorkerPlugin() {
        String env = System.getenv("CAF_STAGING_SERVICE_BASEPATH");
        if (StringUtils.isEmpty((CharSequence)env)) {
            throw new RuntimeException("CAF_STAGING_SERVICE_BASEPATH environment variable not set");
        }
        Optional<Integer> totalSubdocumentLimit = Stream.of(System.getenv("CAF_INGESTION_BATCH_WORKER_SUBDOCUMENT_LIMIT"), "1000").filter(StringUtils::isNotBlank).map(Integer::parseInt).findFirst();
        if (!totalSubdocumentLimit.isPresent()) {
            throw new RuntimeException("CAF_INGESTION_BATCH_WORKER_SUBDOCUMENT_LIMIT was not supplied and the default logic failed.");
        }
        this.fileSystemProvider = new BatchPathProvider(env);
        this.mapper = new ObjectMapper();
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addDeserializer(DocumentWorkerDocument.class, (JsonDeserializer)new DocumentWorkerDocumentDeserializer(totalSubdocumentLimit.get()));
        this.mapper.registerModule((Module)simpleModule);
        this.fieldValidator = IngestionBatchWorkerPlugin.createFieldValidator();
    }

    private static FieldValidatorInterface createFieldValidator() {
        String validationFile = System.getenv("CAF_INGESTION_BATCH_WORKER_VALIDATION_FILEPATH");
        if (StringUtils.isEmpty((CharSequence)validationFile)) {
            return NullFieldValidator.INSTANCE;
        }
        try {
            return new FieldValidator(validationFile);
        }
        catch (IOException ex) {
            log.error("Failed to read validation File: {}", (Object)validationFile, (Object)ex);
            throw new UncheckedIOException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processBatch(BatchWorkerServices batchWorkerServices, String batchDefinition, String taskMessageType, Map<String, String> taskMessageParams) throws BatchDefinitionException, BatchWorkerTransientException {
        log.debug("Definitions received: " + batchDefinition);
        if (taskMessageParams != null) {
            log.debug("Task message params: " + taskMessageParams.toString());
        }
        if (batchDefinition == null || batchDefinition.trim().length() == 0) {
            log.error("IngestionBatchWorkerPlugin has not received a valid batch definition string");
            throw new BatchDefinitionException("IngestionBatchWorkerPlugin has not received a valid batch definition string");
        }
        if (batchDefinition.contains(":")) {
            if (!batchDefinition.startsWith("subbatch:")) {
                log.error("Invalid format of the batch definition: " + batchDefinition);
                throw new BatchDefinitionException("Invalid format of the batch definition: " + batchDefinition);
            }
            try {
                log.debug("Subbatch received: " + batchDefinition);
                this.handleSubbatch(batchDefinition, batchWorkerServices, taskMessageParams);
                return;
            }
            catch (InvalidBatchIdException ex) {
                log.error("Invalid Batch Id Exception! " + ex.getMessage());
                throw new BatchDefinitionException("Invalid Batch Id Exception! " + ex.getMessage());
            }
        }
        if (!batchDefinition.contains("|")) {
            log.debug("Single Batch received: " + batchDefinition);
            this.handleSingleBatchId(batchDefinition, batchWorkerServices);
            return;
        }
        log.debug("Multiple Batches received: " + batchDefinition);
        try {
            IngestionBatchWorkerPlugin.handleMultipleBatchIds(batchDefinition, batchWorkerServices);
            return;
        }
        catch (InvalidBatchIdException | InvalidTenantIdException ex) {
            log.error("Invalid Batch or Tenant Id Exception! " + ex.getMessage());
            throw new BatchDefinitionException("Invalid Tenant or Batch Id Exception! " + ex.getMessage());
        }
    }

    private static void handleMultipleBatchIds(String batchIds, BatchWorkerServices batchWorkerServices) throws BatchDefinitionException, InvalidTenantIdException, InvalidBatchIdException {
        TenantId tenantId = new TenantId(IngestionBatchWorkerPlugin.extractTenantId(batchIds));
        List<BatchId> batchesSplit = IngestionBatchWorkerPlugin.extractBatchIds(batchIds);
        for (BatchId batch : batchesSplit) {
            batchWorkerServices.registerBatchSubtask(tenantId.getValue() + "/" + batch.getValue());
        }
    }

    private void handleSingleBatchId(String batchId, BatchWorkerServices batchWorkerServices) throws BatchDefinitionException {
        try {
            TenantId tenantId = new TenantId(IngestionBatchWorkerPlugin.extractTenantId(batchId));
            BatchId batchIdExtracted = IngestionBatchWorkerPlugin.extractBatchIds(batchId).get(0);
            Path pathOfSubBatches = this.fileSystemProvider.getPathForBatch(tenantId, batchIdExtracted);
            IngestionBatchWorkerPlugin.throwIOExceptionIfFileIsNotAccessible(pathOfSubBatches);
            String[] extensions = new String[]{"batch"};
            Collection subbatchesFiles = FileUtils.listFiles((File)pathOfSubBatches.toFile(), (String[])extensions, (boolean)false);
            for (File subbatch : subbatchesFiles) {
                log.debug("Batch file found: " + subbatch.getName());
                batchWorkerServices.registerBatchSubtask("subbatch:" + tenantId.getValue() + "/" + batchIdExtracted.getValue() + "/" + subbatch.getName());
            }
        }
        catch (IllegalArgumentException ex) {
            log.error("Exception while reading the batch: " + batchId + " was not found");
            throw new BatchDefinitionException("Exception while reading the batch: " + batchId + " was not found");
        }
        catch (InvalidBatchIdException | InvalidTenantIdException ex) {
            log.error("Exception while handling single batch id: " + ex.getMessage());
            throw new BatchDefinitionException("Exception while handling a single batch id: " + ex.getMessage());
        }
        catch (IOException ex) {
            log.error("Exception while reading the batch: " + batchId + " was not found", (Throwable)ex);
            throw new BatchDefinitionException("Exception while reading the batch: " + batchId + " was not found", (Throwable)ex);
        }
    }

    private static void throwIOExceptionIfFileIsNotAccessible(Path path) throws IOException {
        path.getFileSystem().provider().checkAccess(path, new AccessMode[0]);
    }

    private void handleSubbatch(String subbatch, BatchWorkerServices batchWorkerServices, Map<String, String> taskMessageParams) throws InvalidBatchIdException, BatchWorkerTransientException, BatchDefinitionException {
        Subbatch subbatchObj = IngestionBatchWorkerPlugin.extractSubbatch(subbatch);
        Path pathOfSubBatches = this.fileSystemProvider.getPathForBatch(subbatchObj.getTenantId(), subbatchObj.getBatchId());
        Path subbatchFileName = Paths.get(pathOfSubBatches.toString(), subbatchObj.getFileName());
        log.debug("I am going to read each line of: " + subbatchFileName);
        ArrayList<String> lines = new ArrayList<String>();
        try {
            IngestionBatchWorkerPlugin.throwBatchExceptionIfFileIsNotAccessible(subbatch, subbatchFileName);
            lines.addAll(Files.readAllLines(subbatchFileName));
        }
        catch (IOException ex) {
            log.error("Transient exception while reading subbatch: " + subbatchFileName + ", message: " + ex.getMessage());
            throw new BatchWorkerTransientException("Transient exception while reading subbatch: " + subbatchFileName + ", message: " + ex.getMessage());
        }
        ArrayList<DocumentWorkerDocumentTask> documents = new ArrayList<DocumentWorkerDocumentTask>();
        for (String line : lines) {
            try {
                documents.add(this.createDocument(line, taskMessageParams));
            }
            catch (IOException ex) {
                log.error("Exception while deserializing the json of " + line + "\nFile: " + subbatchFileName + "\n" + ex.getMessage());
                throw new RuntimeException("Exception while deserializing the json of " + line + "\nFile: " + subbatchFileName + "\n" + ex.getMessage());
            }
        }
        for (DocumentWorkerDocumentTask document : documents) {
            log.debug("I am going to registers an Item Subtask for: " + document.document.reference);
            batchWorkerServices.registerItemSubtask("DocumentWorkerTask", 1, (Object)document);
        }
    }

    private static void throwBatchExceptionIfFileIsNotAccessible(String subbatch, Path subbatchFileName) throws BatchDefinitionException {
        try {
            IngestionBatchWorkerPlugin.throwIOExceptionIfFileIsNotAccessible(subbatchFileName);
        }
        catch (IOException ex) {
            log.error("Exception while reading subbatch: " + subbatch + ", it does not exist", (Throwable)ex);
            throw new BatchDefinitionException("Exception while reading subbatch: " + subbatch + ", it does not exist", (Throwable)ex);
        }
    }

    private DocumentWorkerDocumentTask createDocument(String line, Map<String, String> taskMessageParams) throws IOException, BatchDefinitionException {
        List<DocumentWorkerScript> scripts;
        DocumentWorkerDocumentTask document = (DocumentWorkerDocumentTask)this.mapper.readValue(line, DocumentWorkerDocumentTask.class);
        document.document = this.fieldValidator.validate(document.document);
        Map<String, String> customData = IngestionBatchWorkerPlugin.populateCustomData(taskMessageParams);
        if (!customData.isEmpty()) {
            document.customData = customData;
        }
        if (!(scripts = IngestionBatchWorkerPlugin.populateScripts(taskMessageParams)).isEmpty()) {
            document.scripts = scripts;
        }
        return document;
    }

    private static String extractTenantId(String batchIds) throws BatchDefinitionException {
        int tenantDelimiter = batchIds.indexOf("/");
        if (tenantDelimiter == -1) {
            log.error("The tenant id is not present in the string passed");
            throw new BatchDefinitionException("The tenant id is not present in the string passed");
        }
        String tenantId = batchIds.substring(0, tenantDelimiter);
        if (tenantId.isEmpty()) {
            log.error("The tenant id is not present in the string passed");
            throw new BatchDefinitionException("The tenant id is not present in the string passed");
        }
        return tenantId;
    }

    private static List<BatchId> extractBatchIds(String batchIds) throws BatchDefinitionException, InvalidBatchIdException {
        ArrayList<BatchId> batchList = new ArrayList<BatchId>();
        int tenantDelimiter = batchIds.indexOf("/");
        Object[] batchesSplit = batchIds.substring(tenantDelimiter + 1, batchIds.length()).split("\\|");
        if (batchesSplit.length == 0) {
            log.error("No batch ids were found");
            throw new BatchDefinitionException("No batch ids were found");
        }
        log.debug("Batch Id(s) found: " + Arrays.toString(batchesSplit));
        for (Object batch : batchesSplit) {
            batchList.add(new BatchId((String)batch));
        }
        return batchList;
    }

    private static Subbatch extractSubbatch(String subbatch) throws BatchDefinitionException, InvalidBatchIdException {
        String subbatchOnlyPart = subbatch.substring(subbatch.lastIndexOf("/") + 1, subbatch.length());
        if (StringUtils.isEmpty((CharSequence)subbatchOnlyPart)) {
            log.error("No subbatch was found");
            throw new BatchDefinitionException("No subbatch was found");
        }
        String tenantId = IngestionBatchWorkerPlugin.extractTenantId(subbatch.substring(subbatch.indexOf(":") + 1, subbatch.length()));
        String batchId = IngestionBatchWorkerPlugin.extractBatchIds(subbatch.substring(subbatch.indexOf(":") + 1, subbatch.lastIndexOf("/"))).get(0).getValue();
        try {
            return new Subbatch(subbatchOnlyPart, tenantId, batchId);
        }
        catch (InvalidBatchIdException | InvalidTenantIdException ex) {
            log.error("Exception: " + ex.getMessage());
            throw new BatchDefinitionException("Exception: " + ex.getMessage());
        }
    }

    private static Map<String, String> populateCustomData(Map<String, String> taskMessageParams) throws BatchDefinitionException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (taskMessageParams != null && !taskMessageParams.isEmpty()) {
            for (Map.Entry<Object, Object> entry : taskMessageParams.entrySet()) {
                if (!((String)entry.getKey()).contains(":")) {
                    log.error("Unable to act on task param as it contains an unrecognized field. Task param key was %s, task param value was %s. Field names should be prefixed with one of the following, field, cd, customdata or graaljs. Key: " + (String)entry.getKey() + ", Value: " + (String)entry.getValue());
                    throw new BatchDefinitionException(String.format("Unable to act on task param as it contains an unrecognized field. Task param key was %s, task param value was %s. Field names should be prefixed with one of the following, field, cd, customdata or graaljs.", entry.getKey(), entry.getValue()));
                }
                String paramType = ((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf(":"));
                if (paramType.equals("customdata")) {
                    map.put(IngestionBatchWorkerPlugin.createKey((String)entry.getKey()), (String)entry.getValue());
                    continue;
                }
                if (!paramType.equals("cd")) continue;
                map.put(IngestionBatchWorkerPlugin.createKey((String)entry.getKey()), (String)entry.getValue());
            }
        }
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            log.debug("Custom Data found: " + (String)entry.getKey() + ", value: " + (String)entry.getValue());
        }
        return map;
    }

    private static List<DocumentWorkerScript> populateScripts(Map<String, String> taskMessageParams) throws BatchDefinitionException {
        ArrayList<DocumentWorkerScript> list = new ArrayList<DocumentWorkerScript>();
        if (taskMessageParams != null && !taskMessageParams.isEmpty()) {
            for (Map.Entry entry : taskMessageParams.entrySet()) {
                DocumentWorkerScript script;
                if (!((String)entry.getKey()).contains(":")) {
                    log.error("Unable to act on task param as it contains an unrecognized field. Task param key was %s, task param value was %s. Field names should be prefixed with one of the following, field, cd, customdata or graaljs. Key: " + (String)entry.getKey() + ", Value: " + (String)entry.getValue());
                    throw new BatchDefinitionException(String.format("Unable to act on task param as it contains an unrecognized field. Task param key was %s, task param value was %s. Field names should be prefixed with one of the following, field, cd, customdata or graaljs.", entry.getKey(), entry.getValue()));
                }
                String paramType = ((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf(":"));
                if (paramType.equals("scripts")) {
                    script = new DocumentWorkerScript();
                    script.name = IngestionBatchWorkerPlugin.createKey((String)entry.getKey());
                    script.script = (String)entry.getValue();
                    list.add(script);
                    continue;
                }
                if (!paramType.equals("graaljs")) continue;
                script = new DocumentWorkerScript();
                script.name = IngestionBatchWorkerPlugin.createKey((String)entry.getKey());
                script.engine = "GRAAL_JS";
                script.script = (String)entry.getValue();
                list.add(script);
            }
        }
        for (DocumentWorkerScript documentWorkerScript : list) {
            log.debug("Script found: " + documentWorkerScript.name);
        }
        return list;
    }

    private static String createKey(String key) {
        return key.substring(key.indexOf(":") + 1, key.length());
    }
}

