/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.worker.ingestion.validator;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.cafdataprocessing.worker.ingestion.validator.FieldValidatorInterface;
import com.github.cafdataprocessing.worker.ingestion.validator.ValidationFileAdapter;
import com.hpe.caf.worker.document.DocumentWorkerDocument;
import com.hpe.caf.worker.document.DocumentWorkerFailure;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FieldValidator
implements FieldValidatorInterface {
    private static final Logger log = LoggerFactory.getLogger(FieldValidator.class);
    private final List<Pattern> allowedFieldPatterns;
    private final ObjectMapper mapper = new ObjectMapper();

    public FieldValidator(String validationFile) throws IOException {
        this.allowedFieldPatterns = ValidationFileAdapter.getFieldNamePatterns(validationFile);
    }

    @Override
    public DocumentWorkerDocument validate(DocumentWorkerDocument document) {
        if (document.fields != null) {
            HashSet keySet = new HashSet(document.fields.keySet());
            if (document.failures == null) {
                document.failures = new ArrayList();
            }
            for (String key : keySet) {
                if (this.isValidField(key)) continue;
                DocumentWorkerFailure fieldNotAllowedFailure = new DocumentWorkerFailure();
                fieldNotAllowedFailure.failureId = "IW-001";
                fieldNotAllowedFailure.failureMessage = key + " is not allowed to be set by the agent.  Value sent: " + this.tryGetFieldValue(document, key);
                try {
                    document.failures.add(fieldNotAllowedFailure);
                }
                catch (UnsupportedOperationException ex) {
                    ArrayList<DocumentWorkerFailure> writableFailureList = new ArrayList<DocumentWorkerFailure>(document.failures);
                    writableFailureList.add(fieldNotAllowedFailure);
                    document.failures = writableFailureList;
                }
                try {
                    document.fields.remove(key);
                }
                catch (UnsupportedOperationException ex) {
                    HashMap writableFields = new HashMap(document.fields);
                    writableFields.remove(key);
                    document.fields = writableFields;
                }
            }
        }
        if (document.subdocuments != null) {
            ArrayList subDocs = new ArrayList(document.subdocuments);
            subDocs.replaceAll(this::validate);
            document.subdocuments = subDocs;
        }
        return document;
    }

    private boolean isValidField(String fieldKey) {
        return this.allowedFieldPatterns.stream().anyMatch(allowedFieldPattern -> allowedFieldPattern.matcher(fieldKey).matches());
    }

    private String tryGetFieldValue(DocumentWorkerDocument document, String key) {
        try {
            return this.mapper.writeValueAsString(document.fields.get(key));
        }
        catch (JsonProcessingException ex) {
            log.error("Unable to write invalid field value as string", (Throwable)ex);
            return "<Failed to get value>";
        }
    }
}

