/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.worker.ingestion.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

final class ValidationFileAdapter {
    private final JsonNode fieldsJsonNode;
    private final JsonNode typesJsonNode;

    public static List<Pattern> getFieldNamePatterns(String file) throws IOException {
        ValidationFileAdapter adapter = new ValidationFileAdapter(file);
        return adapter.getFieldKeyRegExs().stream().map(Pattern::compile).collect(Collectors.toList());
    }

    private ValidationFileAdapter(String file) throws IOException {
        try (InputStream input = Files.newInputStream(Paths.get(file, new String[0]), new OpenOption[0]);){
            ObjectMapper mapper = new ObjectMapper();
            JsonNode fileContents = mapper.readTree(input);
            this.fieldsJsonNode = fileContents.get("fields");
            this.typesJsonNode = fileContents.get("types");
        }
    }

    private List<String> getFieldKeyRegExs() {
        ArrayList<String> fieldKeyRegExs = new ArrayList<String>();
        this.addRegExsToList(fieldKeyRegExs, "^", this.fieldsJsonNode, "$");
        return fieldKeyRegExs;
    }

    private void addRegExsToList(ArrayList<String> fieldKeyRegExs, String prefix, JsonNode node, String suffix) {
        Iterator fields = node.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            JsonNode objectEncodingNode = ((JsonNode)field.getValue()).get("objectEncoding");
            if (objectEncodingNode != null && objectEncodingNode.asText().equals("flattened")) {
                this.addRegExsToList(fieldKeyRegExs, prefix, field, suffix);
                continue;
            }
            String fieldName = (String)field.getKey();
            fieldKeyRegExs.add(prefix + Pattern.quote(fieldName) + suffix);
        }
    }

    private void addRegExsToList(ArrayList<String> fieldKeyRegExs, String prefix, Map.Entry<String, JsonNode> field, String suffix) {
        String fieldName = field.getKey();
        StringBuilder sb = new StringBuilder(prefix);
        sb.append(Pattern.quote(fieldName));
        String[] fieldType = field.getValue().get("type").asText().split("(?=\\[)", 2);
        long count = fieldType[1].chars().filter(ch -> ch == 91).count();
        sb.append("_");
        int i = 0;
        while ((long)i < count) {
            sb.append("[^_]+_");
            ++i;
        }
        JsonNode node = this.typesJsonNode.get(fieldType[0]);
        this.addRegExsToList(fieldKeyRegExs, sb.toString(), node, suffix);
    }
}

