/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.worker.binaryhash;

import com.hpe.caf.api.Codec;
import com.hpe.caf.api.worker.DataStore;
import com.hpe.caf.api.worker.DataStoreSource;
import com.hpe.caf.api.worker.InvalidTaskException;
import com.hpe.caf.api.worker.TaskRejectedException;
import com.hpe.caf.api.worker.WorkerResponse;
import com.hpe.caf.util.ref.DataSource;
import com.hpe.caf.util.ref.DataSourceException;
import com.hpe.caf.util.ref.ReferencedData;
import com.hpe.caf.worker.AbstractWorker;
import com.hpe.caf.worker.binaryhash.BinaryHashWorkerResult;
import com.hpe.caf.worker.binaryhash.BinaryHashWorkerStatus;
import com.hpe.caf.worker.binaryhash.BinaryHashWorkerTask;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryHashWorker
extends AbstractWorker<BinaryHashWorkerTask, BinaryHashWorkerResult> {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryHashWorker.class);
    private final DataStore dataStore;

    public BinaryHashWorker(BinaryHashWorkerTask task, DataStore dataStore, String outputQueue, Codec codec, long resultSizeThreshold) throws InvalidTaskException {
        super((Object)task, outputQueue, codec);
        this.dataStore = Objects.requireNonNull(dataStore);
    }

    public String getWorkerIdentifier() {
        return "BinaryHashWorker";
    }

    public int getWorkerApiVersion() {
        return 1;
    }

    public WorkerResponse doWork() throws InterruptedException, TaskRejectedException {
        BinaryHashWorkerResult result = this.processFile();
        if (result.workerStatus == BinaryHashWorkerStatus.COMPLETED) {
            return this.createSuccessResult(result);
        }
        return this.createFailureResult(result);
    }

    private BinaryHashWorkerResult processFile() throws InterruptedException {
        LOG.info("Starting work");
        this.checkIfInterrupted();
        DataStoreSource source = new DataStoreSource(this.dataStore, this.getCodec());
        ReferencedData data = ((BinaryHashWorkerTask)this.getTask()).sourceData;
        try {
            InputStream textStream = data.acquire((DataSource)source);
            String hashResult = DigestUtils.sha1Hex((InputStream)textStream);
            BinaryHashWorkerResult workerResult = new BinaryHashWorkerResult();
            workerResult.hashResult = hashResult;
            workerResult.workerStatus = BinaryHashWorkerStatus.COMPLETED;
            return workerResult;
        }
        catch (DataSourceException e) {
            LOG.warn("Error acquiring data", (Throwable)e);
            return this.createErrorResult(BinaryHashWorkerStatus.SOURCE_FAILED);
        }
        catch (IOException e) {
            LOG.warn("Error converting input stream to text", (Throwable)e);
            return this.createErrorResult(BinaryHashWorkerStatus.WORKER_FAILED);
        }
    }

    private BinaryHashWorkerResult createErrorResult(BinaryHashWorkerStatus status) {
        BinaryHashWorkerResult workerResult = new BinaryHashWorkerResult();
        workerResult.workerStatus = status;
        return workerResult;
    }
}

