/*
 * Copyright 2015-2017 EntIT Software LLC, a Micro Focus company.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.hpe.caf.worker.binaryhash;

import com.hpe.caf.api.worker.WorkerConfiguration;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * Configuration for the BinaryHashWorker, read in from test-configs/cfg_test_worker-binaryhash-BinaryHashWorkerConfiguration.
 */
public class BinaryHashWorkerConfiguration extends WorkerConfiguration
{

    /**
     * Output queue to return results to RabbitMQ.
     */
    @NotNull
    @Size(min = 1)
    private String outputQueue;

    /**
     * Number of threads to use in the worker.
     */
    @Min(1)
    @Max(20)
    private int threads;

    /**
     * The size, in bytes, at which to write results to the DataStore instead of keeping them just in memory.
     */
    @Min(1024)
    @Max(100 * 1024)
    private int resultSizeThreshold;

    public BinaryHashWorkerConfiguration()
    {
    }

    public String getOutputQueue()
    {
        return outputQueue;
    }

    public void setOutputQueue(String outputQueue)
    {
        this.outputQueue = outputQueue;
    }

    public int getThreads()
    {
        return threads;
    }

    public void setThreads(int threads)
    {
        this.threads = threads;
    }

    public int getResultSizeThreshold()
    {
        return resultSizeThreshold;
    }

    public void setResultSizeThreshold(int resultSizeThreshold)
    {
        this.resultSizeThreshold = resultSizeThreshold;
    }
}
