/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.worker.boilerplate;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.hpe.caf.util.ref.ReferencedData;
import com.hpe.caf.worker.boilerplate.BoilerplateTestExpectation;
import com.hpe.caf.worker.boilerplate.BoilerplateTestInput;
import com.hpe.caf.worker.boilerplateshared.BoilerplateWorkerTask;
import com.hpe.caf.worker.boilerplateshared.response.BoilerplateWorkerResponse;
import com.hpe.caf.worker.testing.TestConfiguration;
import com.hpe.caf.worker.testing.TestItem;
import com.hpe.caf.worker.testing.preparation.PreparationItemProvider;
import java.nio.file.Path;

public class BoilerplateResultProvider
extends PreparationItemProvider<BoilerplateWorkerTask, BoilerplateWorkerResponse, BoilerplateTestInput, BoilerplateTestExpectation> {
    TestConfiguration configuration;

    public BoilerplateResultProvider(TestConfiguration<BoilerplateWorkerTask, BoilerplateWorkerResponse, BoilerplateTestInput, BoilerplateTestExpectation> configuration) {
        super(configuration);
        this.configuration = configuration;
    }

    protected TestItem createTestItem(Path inputFile, Path expectedFile) throws Exception {
        TestItem item = super.createTestItem(inputFile, expectedFile);
        BoilerplateWorkerTask task = (BoilerplateWorkerTask)this.getTaskTemplate();
        if (task == null) {
            task = new BoilerplateWorkerTask();
        }
        if (task.getDataStorePartialReference() == null) {
            task.setDataStorePartialReference(this.configuration.getDataStoreContainerId());
        }
        if (task.getTenantId() == null) {
            task.setTenantId("DefaultTenantId");
        }
        if (task.getSourceData() == null) {
            task.setSourceData((Multimap)HashMultimap.create());
        }
        item = this.updateItem((TestItem<BoilerplateTestInput, BoilerplateTestExpectation>)item, task, inputFile);
        return item;
    }

    private TestItem updateItem(TestItem<BoilerplateTestInput, BoilerplateTestExpectation> item, BoilerplateWorkerTask task, Path inputFile) {
        BoilerplateTestInput inputData = (BoilerplateTestInput)((Object)item.getInputData());
        inputData.setExpressions(task.getExpressions());
        inputData.setInputFile(inputFile.toString());
        inputData.setRedactionType(task.getRedactionType());
        inputData.setReturnMatches(task.getReturnMatches());
        inputData.setUseDataStore(true);
        inputData.setSourceData((Multimap<String, ReferencedData>)task.getSourceData());
        inputData.setTenantId(task.getTenantId());
        return item;
    }
}

