/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.worker.boilerplate;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.hpe.caf.api.worker.DataStoreSource;
import com.hpe.caf.api.worker.TaskMessage;
import com.hpe.caf.util.ref.DataSource;
import com.hpe.caf.util.ref.DataSourceException;
import com.hpe.caf.util.ref.ReferencedData;
import com.hpe.caf.worker.boilerplate.BoilerplateResultForTest;
import com.hpe.caf.worker.boilerplate.BoilerplateTestExpectation;
import com.hpe.caf.worker.boilerplate.BoilerplateTestInput;
import com.hpe.caf.worker.boilerplateshared.BoilerplateWorkerTask;
import com.hpe.caf.worker.boilerplateshared.response.BoilerplateResult;
import com.hpe.caf.worker.boilerplateshared.response.BoilerplateWorkerResponse;
import com.hpe.caf.worker.boilerplateshared.response.SignatureExtractStatus;
import com.hpe.caf.worker.testing.ContentFileTestExpectation;
import com.hpe.caf.worker.testing.TestConfiguration;
import com.hpe.caf.worker.testing.TestItem;
import com.hpe.caf.worker.testing.WorkerServices;
import com.hpe.caf.worker.testing.data.ContentComparisonType;
import com.hpe.caf.worker.testing.preparation.PreparationResultProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class BoilerplateSaveResultProcessor
extends PreparationResultProcessor<BoilerplateWorkerTask, BoilerplateWorkerResponse, BoilerplateTestInput, BoilerplateTestExpectation> {
    private TestConfiguration configuration;
    private WorkerServices workerServices;

    protected BoilerplateSaveResultProcessor(TestConfiguration<BoilerplateWorkerTask, BoilerplateWorkerResponse, BoilerplateTestInput, BoilerplateTestExpectation> configuration, WorkerServices workerServices) {
        super(configuration, workerServices.getCodec());
        this.configuration = configuration;
        this.workerServices = workerServices;
    }

    protected byte[] getOutputContent(BoilerplateWorkerResponse boilerplateWorkerResponse, TaskMessage message, TestItem<BoilerplateTestInput, BoilerplateTestExpectation> testItem) throws Exception {
        ((BoilerplateTestExpectation)((Object)testItem.getExpectedOutputData())).setTaskResults(this.convertMap(boilerplateWorkerResponse.getTaskResults(), testItem));
        return super.getOutputContent((Object)boilerplateWorkerResponse, message, testItem);
    }

    private Map<String, BoilerplateResultForTest> convertMap(Map<String, BoilerplateResult> map, TestItem<BoilerplateTestInput, BoilerplateTestExpectation> testItem) {
        HashMap<String, BoilerplateResultForTest> updatedMap = new HashMap<String, BoilerplateResultForTest>();
        map.forEach((k, v) -> {
            try {
                updatedMap.put((String)k, this.convertResult((BoilerplateResult)v, testItem));
            }
            catch (DataSourceException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return updatedMap;
    }

    private BoilerplateResultForTest convertResult(BoilerplateResult result, TestItem<BoilerplateTestInput, BoilerplateTestExpectation> testItem) throws DataSourceException, IOException {
        SignatureExtractStatus signatureExtractStatus;
        Multimap groupedMatches;
        BoilerplateResultForTest resultForTest = new BoilerplateResultForTest();
        resultForTest.setMatches(result.getMatches());
        Collection resultData = result.getData();
        if (resultData != null) {
            this.convertReferencedData(resultData, resultForTest, testItem);
        }
        if ((groupedMatches = result.getGroupedMatches()) != null) {
            this.convertGroupedMatches((Multimap<String, ReferencedData>)groupedMatches, resultForTest, testItem);
        }
        if ((signatureExtractStatus = result.getSignatureExtractStatus()) != null) {
            resultForTest.setSignatureExtractStatus(signatureExtractStatus);
        }
        return resultForTest;
    }

    private void convertReferencedData(Collection<ReferencedData> resultData, BoilerplateResultForTest resultForTest, TestItem<BoilerplateTestInput, BoilerplateTestExpectation> testItem) throws DataSourceException, IOException {
        Collection<ContentFileTestExpectation> testResultData = resultForTest.getData();
        if (testResultData == null) {
            testResultData = new ArrayList<ContentFileTestExpectation>();
            resultForTest.setData(testResultData);
        }
        for (ReferencedData data : resultData) {
            ContentFileTestExpectation expectation = new ContentFileTestExpectation();
            expectation.setComparisonType(ContentComparisonType.BINARY);
            expectation.setExpectedSimilarityPercentage(100);
            Path savePath = Paths.get(this.configuration.getTestDataFolder(), testItem.getTag() + ".content");
            DataStoreSource dataSource = new DataStoreSource(this.workerServices.getDataStore(), this.workerServices.getCodec());
            String content = IOUtils.toString((InputStream)data.acquire((DataSource)dataSource));
            Files.write(savePath, content.getBytes(), StandardOpenOption.CREATE);
            expectation.setExpectedContentFile(savePath.toString());
            testResultData.add(expectation);
        }
    }

    private void convertGroupedMatches(Multimap<String, ReferencedData> groupedMatches, BoilerplateResultForTest resultForTest, TestItem<BoilerplateTestInput, BoilerplateTestExpectation> testItem) {
        if (resultForTest.getGroupedMatches() == null) {
            resultForTest.setGroupedMatches((Multimap<String, ContentFileTestExpectation>)LinkedListMultimap.create());
        }
        groupedMatches.entries().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase("BOILERPLATE_PRIMARY_CONTENT") || ((String)entry.getKey()).equalsIgnoreCase("BOILERPLATE_SECONDARY_CONTENT") || ((String)entry.getKey()).equalsIgnoreCase("BOILERPLATE_TERTIARY_CONTENT")).forEach(entry -> {
            try {
                ContentFileTestExpectation expectation = new ContentFileTestExpectation();
                expectation.setComparisonType(ContentComparisonType.BINARY);
                expectation.setExpectedSimilarityPercentage(100);
                Path savePath = Paths.get(this.configuration.getTestDataFolder(), testItem.getTag() + this.getFileExtension((String)entry.getKey()));
                DataStoreSource dataSource = new DataStoreSource(this.workerServices.getDataStore(), this.workerServices.getCodec());
                String content = IOUtils.toString((InputStream)((ReferencedData)entry.getValue()).acquire((DataSource)dataSource));
                Files.write(savePath, content.getBytes(), StandardOpenOption.CREATE);
                expectation.setExpectedContentFile(savePath.toString());
                resultForTest.getGroupedMatches().put(entry.getKey(), (Object)expectation);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (DataSourceException e) {
                e.printStackTrace();
            }
        });
        Integer[] numOfSignatures = new Integer[]{0};
        groupedMatches.entries().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase("BOILERPLATE_EXTRACTED_SIGNATURES")).forEach(entry -> {
            try {
                Integer n = numOfSignatures[0];
                Integer n2 = integerArray[0] = Integer.valueOf(numOfSignatures[0] + 1);
                ContentFileTestExpectation expectation = new ContentFileTestExpectation();
                expectation.setComparisonType(ContentComparisonType.BINARY);
                expectation.setExpectedSimilarityPercentage(100);
                String[] split = testItem.getTag().split("/");
                String testCaseName = split.length > 1 ? split[split.length - 1] : testItem.getTag();
                Path savePath = Paths.get(this.configuration.getTestDataFolder(), testItem.getTag() + "-signatures", testCaseName + this.getFileExtension((String)entry.getKey()) + numOfSignatures[0]);
                DataStoreSource dataSource = new DataStoreSource(this.workerServices.getDataStore(), this.workerServices.getCodec());
                String content = IOUtils.toString((InputStream)((ReferencedData)entry.getValue()).acquire((DataSource)dataSource));
                Files.createDirectories(savePath.getParent(), new FileAttribute[0]);
                Files.write(savePath, content.getBytes(), StandardOpenOption.CREATE);
                expectation.setExpectedContentFile(savePath.toString());
                resultForTest.getGroupedMatches().put(entry.getKey(), (Object)expectation);
            }
            catch (DataSourceException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private String getFileExtension(String key) {
        if (key.equalsIgnoreCase("BOILERPLATE_PRIMARY_CONTENT")) {
            return ".primary";
        }
        if (key.equalsIgnoreCase("BOILERPLATE_SECONDARY_CONTENT")) {
            return ".secondary";
        }
        if (key.equalsIgnoreCase("BOILERPLATE_TERTIARY_CONTENT")) {
            return ".tertiary";
        }
        if (key.equalsIgnoreCase("BOILERPLATE_EXTRACTED_SIGNATURES")) {
            return ".signature";
        }
        return ".content";
    }
}

