/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.worker.document.testing;

import com.hpe.caf.api.ConfigurationException;
import com.hpe.caf.api.ConfigurationSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CodeConfigurationSource
implements ConfigurationSource {
    private final Map<Class, Object> configurations = new HashMap<Class, Object>();

    public CodeConfigurationSource(Object ... configurations) {
        if (configurations == null) {
            return;
        }
        for (Object configuration : configurations) {
            this.addConfiguration(configuration, false);
        }
    }

    public <T> T getConfiguration(Class<T> configClass) throws ConfigurationException {
        Objects.requireNonNull(configClass);
        if (!this.configurations.containsKey(configClass)) {
            throw new ConfigurationException("Could not find " + configClass.getName());
        }
        return (T)this.configurations.get(configClass);
    }

    public CodeConfigurationSource addConfiguration(Object configuration) {
        return this.addConfiguration(configuration, false);
    }

    public CodeConfigurationSource addConfiguration(Object configuration, boolean overrideIfExists) {
        Class<?> configurationClass = configuration.getClass();
        if (!overrideIfExists && this.configurations.containsKey(configurationClass)) {
            throw new IllegalArgumentException(String.format("Configuration for %s already set.", configurationClass.getName()));
        }
        this.configurations.put(configurationClass, configuration);
        return this;
    }
}

