/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.worker.document.testing;

import com.hpe.caf.worker.document.DocumentWorkerFieldEncoding;
import com.hpe.caf.worker.document.DocumentWorkerFieldValue;
import com.hpe.caf.worker.document.testing.DocumentBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;

public class FieldsBuilder {
    private final Map<String, List<DocumentWorkerFieldValue>> fields;
    private final DocumentBuilder parentBuilder;

    FieldsBuilder(Map<String, List<DocumentWorkerFieldValue>> fields, DocumentBuilder parentBuilder) {
        this.fields = Objects.requireNonNull(fields);
        this.parentBuilder = parentBuilder;
    }

    private static DocumentWorkerFieldValue createFieldValue(String data, DocumentWorkerFieldEncoding encoding) {
        DocumentWorkerFieldValue value = new DocumentWorkerFieldValue();
        value.data = data;
        value.encoding = encoding;
        return value;
    }

    public DocumentBuilder documentBuilder() {
        return this.parentBuilder;
    }

    public FieldValuesBuilder addField(String fieldName) {
        Objects.requireNonNull(fieldName);
        List<DocumentWorkerFieldValue> fieldValues = this.getFieldValues(fieldName);
        return new FieldValuesBuilder(fieldValues, this);
    }

    public FieldsBuilder addFieldValues(String fieldName, String ... values) {
        Objects.requireNonNull(fieldName);
        Objects.requireNonNull(values);
        return this.addFieldValues(fieldName, DocumentWorkerFieldEncoding.utf8, values);
    }

    public FieldsBuilder addFieldValues(String fieldName, DocumentWorkerFieldEncoding encoding, String ... values) {
        Objects.requireNonNull(fieldName);
        Objects.requireNonNull(values);
        for (String value : values) {
            this.addFieldValue(fieldName, value, encoding);
        }
        return this;
    }

    public FieldsBuilder addFieldValue(String fieldName, String data) {
        Objects.requireNonNull(fieldName);
        return this.addFieldValue(fieldName, data, null);
    }

    public FieldsBuilder addFieldValue(String fieldName, String data, DocumentWorkerFieldEncoding encoding) {
        Objects.requireNonNull(fieldName);
        this.addFieldValueInternal(fieldName, data, encoding);
        return this;
    }

    public FieldsBuilder addFieldValue(String fieldName, byte[] data) {
        String base64String = Base64.encodeBase64String((byte[])data);
        this.addFieldValueInternal(fieldName, base64String, DocumentWorkerFieldEncoding.base64);
        return this;
    }

    private List<DocumentWorkerFieldValue> addFieldValueInternal(String fieldName, String data, DocumentWorkerFieldEncoding encoding) {
        List<DocumentWorkerFieldValue> fieldValues = this.getFieldValues(fieldName);
        fieldValues.add(FieldsBuilder.createFieldValue(data, encoding));
        return fieldValues;
    }

    private List<DocumentWorkerFieldValue> getFieldValues(String fieldName) {
        ArrayList<DocumentWorkerFieldValue> fieldValues;
        if (!this.fields.containsKey(fieldName)) {
            fieldValues = new ArrayList();
            this.fields.put(fieldName, fieldValues);
        } else {
            fieldValues = this.fields.get(fieldName);
        }
        return fieldValues;
    }

    public static final class FieldValuesBuilder {
        private final List<DocumentWorkerFieldValue> fieldValues;
        private final FieldsBuilder parentBuilder;

        private FieldValuesBuilder(List<DocumentWorkerFieldValue> fieldValues, FieldsBuilder parentBuilder) {
            this.fieldValues = fieldValues;
            this.parentBuilder = parentBuilder;
        }

        public FieldValuesBuilder addValue(String data) {
            return this.addValue(data, DocumentWorkerFieldEncoding.utf8);
        }

        public FieldValuesBuilder addValue(String data, DocumentWorkerFieldEncoding encoding) {
            this.fieldValues.add(FieldsBuilder.createFieldValue(data, encoding));
            return this;
        }

        public FieldsBuilder then() {
            return this.parentBuilder;
        }
    }
}

