/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.worker.document.testing.hamcrest;

import com.hpe.caf.worker.document.DocumentWorkerFieldEncoding;
import com.hpe.caf.worker.document.model.Document;
import com.hpe.caf.worker.document.model.Field;
import com.hpe.caf.worker.document.model.FieldValue;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public abstract class IsDocumentContainingFieldValue<T>
extends TypeSafeDiagnosingMatcher<Document> {
    private final String fieldName;
    private final Matcher<T> fieldValueMatcher;
    private final DocumentWorkerFieldEncoding encoding;

    public IsDocumentContainingFieldValue(String fieldName, Matcher<T> fieldValueMatcher, DocumentWorkerFieldEncoding encoding) {
        this.fieldName = Objects.requireNonNull(fieldName);
        this.fieldValueMatcher = Objects.requireNonNull(fieldValueMatcher);
        this.encoding = Objects.requireNonNull(encoding);
    }

    protected boolean matchesSafely(Document document, Description description) {
        Field field = document.getField(this.fieldName);
        boolean isPastFirst = false;
        description.appendText("actual value(s) were ");
        for (FieldValue value : field.getValues()) {
            if (!this.isFieldValueOfExpectedType(value)) continue;
            T fieldValue = this.getFieldValue(value);
            if (this.fieldValueMatcher.matches(fieldValue)) {
                return true;
            }
            if (isPastFirst) {
                description.appendText(", ");
            }
            this.describeActual(fieldValue, description);
            isPastFirst = true;
        }
        return false;
    }

    protected abstract void describeActual(T var1, Description var2);

    protected abstract T getFieldValue(FieldValue var1);

    protected abstract boolean isFieldValueOfExpectedType(FieldValue var1);

    public void describeTo(Description description) {
        description.appendText("a document containing field ").appendText(this.fieldName).appendText(" with value ");
        this.fieldValueMatcher.describeTo(description);
    }
}

