/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.worker.document;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.hpe.caf.api.Codec;
import com.hpe.caf.api.worker.DataStore;
import com.hpe.caf.api.worker.DataStoreException;
import com.hpe.caf.util.ref.ReferencedData;
import com.hpe.caf.worker.document.DocumentWorkerFieldEncoding;
import com.hpe.caf.worker.document.DocumentWorkerFieldValue;
import com.hpe.caf.worker.document.DocumentWorkerFieldValueExpectation;
import com.hpe.caf.worker.testing.TestConfiguration;
import com.hpe.caf.worker.testing.validation.CustomPropertyValidator;
import com.hpe.caf.worker.testing.validation.ReferenceDataValidator;
import com.hpe.caf.worker.testing.validation.ValuePropertyValidator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.apache.commons.io.IOUtils;

public class DocumentWorkerFieldValueValidator
extends CustomPropertyValidator {
    private final Collection<String> recognizedPropertyNames;
    private final DataStore dataStore;
    private final ReferenceDataValidator referencedDataValidator;
    private final ValuePropertyValidator simpleValueValidator;
    private final ObjectMapper mapper = new ObjectMapper();

    public DocumentWorkerFieldValueValidator(DataStore dataStore, TestConfiguration testConfiguration, Codec codec, String ... recognizedPropertyNames) {
        this.dataStore = Objects.requireNonNull(dataStore);
        this.referencedDataValidator = new ReferenceDataValidator(false, dataStore, codec, testConfiguration.getTestDataFolder(), testConfiguration.getTestSourcefileBaseFolder());
        this.simpleValueValidator = new ValuePropertyValidator();
        this.recognizedPropertyNames = Arrays.asList(recognizedPropertyNames);
        this.mapper.registerModule((Module)new GuavaModule());
    }

    public boolean canValidate(String propertyName, Object sourcePropertyValue, Object validatorPropertyValue) {
        boolean nameCheckPassed = this.recognizedPropertyNames.isEmpty() || propertyName != null && this.recognizedPropertyNames.contains(propertyName);
        return nameCheckPassed && this.isDocumentWorkerFieldValue(sourcePropertyValue) && this.isDocumentWorkerFieldValueExpectation(validatorPropertyValue);
    }

    protected boolean isValid(Object testedPropertyValue, Object validatorPropertyValue) {
        if (testedPropertyValue == null && validatorPropertyValue == null) {
            return true;
        }
        if (testedPropertyValue == null || validatorPropertyValue == null) {
            return false;
        }
        try {
            DocumentWorkerFieldValue testedValue = this.convert(DocumentWorkerFieldValue.class, testedPropertyValue);
            DocumentWorkerFieldValueExpectation validatorValue = this.convert(DocumentWorkerFieldValueExpectation.class, validatorPropertyValue);
            return testedValue != null && validatorValue != null && this.equal(testedValue, validatorValue);
        }
        catch (DataStoreException | IOException e) {
            return false;
        }
    }

    private boolean isDocumentWorkerFieldValue(Object value) {
        return this.convert(DocumentWorkerFieldValue.class, value) != null;
    }

    private boolean isDocumentWorkerFieldValueExpectation(Object value) {
        return this.convert(DocumentWorkerFieldValueExpectation.class, value) != null;
    }

    private <T> T convert(Class<T> type, Object value) {
        if (type.isInstance(value)) {
            return (T)value;
        }
        if (value instanceof LinkedHashMap) {
            try {
                return (T)this.mapper.convertValue(value, type);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean equal(DocumentWorkerFieldValue actual, DocumentWorkerFieldValueExpectation expected) throws DataStoreException, IOException {
        DocumentWorkerFieldEncoding expectedValueEncoding = DocumentWorkerFieldValueValidator.nullToUtf8(expected.encoding);
        if (expectedValueEncoding == DocumentWorkerFieldEncoding.storage_ref) {
            return this.referencedDataValidator.isValid((Object)this.getReferencedData(actual), (Object)expected.content);
        }
        String actualValue = DocumentWorkerFieldValueValidator.nullToUtf8(actual.encoding) == expectedValueEncoding ? DocumentWorkerFieldValueValidator.nullToEmpty(actual.data) : (expectedValueEncoding == DocumentWorkerFieldEncoding.base64 ? (Object)this.getBytes(actual) : new String(this.getBytes(actual)));
        return this.simpleValueValidator.isValid((Object)actualValue, (Object)DocumentWorkerFieldValueValidator.nullToEmpty(expected.data));
    }

    private ReferencedData getReferencedData(DocumentWorkerFieldValue actual) throws DataStoreException, IOException {
        return DocumentWorkerFieldValueValidator.nullToUtf8(actual.encoding) == DocumentWorkerFieldEncoding.storage_ref ? ReferencedData.getReferencedData((String)DocumentWorkerFieldValueValidator.nullToEmpty(actual.data)) : ReferencedData.getWrappedData((byte[])this.getBytes(actual));
    }

    private byte[] getBytes(DocumentWorkerFieldValue value) throws DataStoreException, IOException {
        return this.getBytes(value.encoding, value.data);
    }

    private byte[] getBytes(DocumentWorkerFieldEncoding encoding, String data) throws DataStoreException, IOException {
        String nonNullData = DocumentWorkerFieldValueValidator.nullToEmpty(data);
        switch (DocumentWorkerFieldValueValidator.nullToUtf8(encoding)) {
            case storage_ref: {
                return IOUtils.toByteArray((InputStream)this.dataStore.retrieve(nonNullData));
            }
            case base64: {
                return Base64.getDecoder().decode(nonNullData);
            }
        }
        return nonNullData.getBytes(StandardCharsets.UTF_8);
    }

    private static String nullToEmpty(String str) {
        return str != null ? str : "";
    }

    private static DocumentWorkerFieldEncoding nullToUtf8(DocumentWorkerFieldEncoding encoding) {
        return encoding != null ? encoding : DocumentWorkerFieldEncoding.utf8;
    }
}

