/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.worker.document;

import com.hpe.caf.worker.document.DocumentWorkerResult;
import com.hpe.caf.worker.document.DocumentWorkerTask;
import com.hpe.caf.worker.document.DocumentWorkerTestExpectation;
import com.hpe.caf.worker.document.DocumentWorkerTestInput;
import com.hpe.caf.worker.testing.TestConfiguration;
import com.hpe.caf.worker.testing.TestItem;
import com.hpe.caf.worker.testing.TestItemProvider;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DocumentWorkerResultPreparationProvider
implements TestItemProvider {
    private final TestConfiguration<DocumentWorkerTask, DocumentWorkerResult, DocumentWorkerTestInput, DocumentWorkerTestExpectation> configuration;
    private final String inputPath;
    private final String expectedPath;
    private final String globPattern;
    private final boolean includeSubFolders;

    public DocumentWorkerResultPreparationProvider(TestConfiguration<DocumentWorkerTask, DocumentWorkerResult, DocumentWorkerTestInput, DocumentWorkerTestExpectation> configuration) {
        this.configuration = configuration;
        this.inputPath = configuration.getTestDocumentsFolder();
        this.expectedPath = configuration.getTestDataFolder();
        this.globPattern = "regex:^(?!.*[.](content|testcase)$).*$";
        this.includeSubFolders = true;
    }

    public Collection<TestItem> getItems() throws Exception {
        List<Path> files = this.getFiles(Paths.get(this.inputPath, new String[0]));
        ArrayList<TestItem> testItems = new ArrayList<TestItem>(files.size());
        for (Path inputFile : files) {
            testItems.add(this.createTestItem(inputFile));
        }
        return testItems;
    }

    private List<Path> getFiles(Path directory) throws IOException {
        ArrayList<Path> fileNames = new ArrayList<Path>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
            for (Path path : directoryStream) {
                if (Files.isDirectory(path, new LinkOption[0]) && this.includeSubFolders) {
                    fileNames.addAll(this.getFiles(path));
                    continue;
                }
                if (this.globPattern != null && !path.getFileSystem().getPathMatcher(this.globPattern).matches(path.getFileName())) continue;
                fileNames.add(path);
            }
        }
        catch (IOException e) {
            System.out.println(e);
            throw e;
        }
        return fileNames;
    }

    private TestItem createTestItem(Path inputFile) throws Exception {
        DocumentWorkerTestInput testInput = (DocumentWorkerTestInput)this.configuration.getInputClass().newInstance();
        String normalizedRelativePath = Paths.get(this.expectedPath, new String[0]).relativize(inputFile).toString().replace("\\", "/");
        DocumentWorkerTestExpectation testExpectation = (DocumentWorkerTestExpectation)this.configuration.getExpectationClass().newInstance();
        TestItem testItem = new TestItem(normalizedRelativePath, (Object)testInput, (Object)testExpectation);
        ((DocumentWorkerTestInput)testItem.getInputData()).setTask(this.createDocumentWorkerTask(inputFile));
        return testItem;
    }

    private DocumentWorkerTask createDocumentWorkerTask(Path inputFile) {
        try {
            return (DocumentWorkerTask)this.configuration.getSerializer().readValue(inputFile.toFile(), this.configuration.getWorkerTaskClass());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new AssertionError((Object)("Failed to deserialize inputFile task: " + inputFile + ". Message: " + e.getMessage()));
        }
    }
}

