/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.worker.document;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.hpe.caf.api.worker.TaskMessage;
import com.hpe.caf.worker.document.DocumentWorkerFieldValueValidator;
import com.hpe.caf.worker.document.DocumentWorkerResult;
import com.hpe.caf.worker.document.DocumentWorkerResultExpectation;
import com.hpe.caf.worker.document.DocumentWorkerTask;
import com.hpe.caf.worker.document.DocumentWorkerTestExpectation;
import com.hpe.caf.worker.testing.TestConfiguration;
import com.hpe.caf.worker.testing.TestItem;
import com.hpe.caf.worker.testing.WorkerServices;
import com.hpe.caf.worker.testing.configuration.ValidationSettings;
import com.hpe.caf.worker.testing.validation.CustomPropertyValidator;
import com.hpe.caf.worker.testing.validation.PropertyMap;
import com.hpe.caf.worker.testing.validation.PropertyValidatingProcessor;
import java.util.Map;

public class DocumentWorkerResultValidationProcessor<TTestInput>
extends PropertyValidatingProcessor<DocumentWorkerResult, TTestInput, DocumentWorkerTestExpectation> {
    public DocumentWorkerResultValidationProcessor(TestConfiguration<DocumentWorkerTask, DocumentWorkerResult, TTestInput, DocumentWorkerTestExpectation> testConfiguration, WorkerServices workerServices) {
        super(testConfiguration, workerServices, ValidationSettings.configure().customValidators(new CustomPropertyValidator[]{new DocumentWorkerFieldValueValidator(workerServices.getDataStore(), testConfiguration, workerServices.getCodec(), new String[0])}).build());
    }

    protected boolean processWorkerResult(TestItem<TTestInput, DocumentWorkerTestExpectation> testItem, TaskMessage message, DocumentWorkerResult workerResult) throws Exception {
        return super.processWorkerResult(testItem, message, (Object)workerResult);
    }

    protected boolean isCompleted(TestItem<TTestInput, DocumentWorkerTestExpectation> testItem, TaskMessage message, DocumentWorkerResult documentWorkerResult) {
        return true;
    }

    protected Map<String, Object> getExpectationMap(TestItem<TTestInput, DocumentWorkerTestExpectation> testItem, TaskMessage message, DocumentWorkerResult documentWorkerResult) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new GuavaModule());
        DocumentWorkerResultExpectation expectation = ((DocumentWorkerTestExpectation)testItem.getExpectedOutputData()).getResult();
        PropertyMap expectationPropertyMap = this.convert(expectation);
        return expectationPropertyMap;
    }

    protected Object getValidatedObject(TestItem<TTestInput, DocumentWorkerTestExpectation> testItem, TaskMessage message, DocumentWorkerResult documentWorkerResult) {
        return this.convert(documentWorkerResult);
    }

    private PropertyMap convert(DocumentWorkerResult result) {
        PropertyMap propertyMap = new PropertyMap();
        if (result != null) {
            if (result.fieldChanges != null) {
                propertyMap.put((Object)"fieldChanges", (Object)result.fieldChanges);
            }
            if (result.failures != null) {
                propertyMap.put((Object)"failures", (Object)result.failures);
            }
        }
        return propertyMap;
    }

    private PropertyMap convert(DocumentWorkerResultExpectation result) {
        PropertyMap propertyMap = new PropertyMap();
        if (result.fieldChanges != null) {
            propertyMap.put((Object)"fieldChanges", result.fieldChanges);
        }
        if (result.failures != null) {
            propertyMap.put((Object)"failures", result.failures);
        }
        return propertyMap;
    }
}

