/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.worker.document;

import com.hpe.caf.api.worker.DataStoreException;
import com.hpe.caf.api.worker.TaskMessage;
import com.hpe.caf.worker.document.DocumentWorkerFieldChanges;
import com.hpe.caf.worker.document.DocumentWorkerFieldChangesExpectation;
import com.hpe.caf.worker.document.DocumentWorkerFieldEncoding;
import com.hpe.caf.worker.document.DocumentWorkerFieldValue;
import com.hpe.caf.worker.document.DocumentWorkerFieldValueExpectation;
import com.hpe.caf.worker.document.DocumentWorkerResult;
import com.hpe.caf.worker.document.DocumentWorkerResultExpectation;
import com.hpe.caf.worker.document.DocumentWorkerTask;
import com.hpe.caf.worker.document.DocumentWorkerTestExpectation;
import com.hpe.caf.worker.testing.ContentFileTestExpectation;
import com.hpe.caf.worker.testing.OutputToFileProcessor;
import com.hpe.caf.worker.testing.TestConfiguration;
import com.hpe.caf.worker.testing.TestItem;
import com.hpe.caf.worker.testing.WorkerServices;
import com.hpe.caf.worker.testing.data.ContentComparisonType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;

public class DocumentWorkerSaveResultProcessor<TTestInput>
extends OutputToFileProcessor<DocumentWorkerResult, TTestInput, DocumentWorkerTestExpectation> {
    private TestConfiguration configuration;
    private final WorkerServices workerServices;

    public DocumentWorkerSaveResultProcessor(TestConfiguration<DocumentWorkerTask, DocumentWorkerResult, TTestInput, DocumentWorkerTestExpectation> configuration, WorkerServices workerServices) {
        super(workerServices.getCodec(), configuration.getWorkerResultClass(), configuration.getTestDataFolder());
        this.configuration = configuration;
        this.workerServices = workerServices;
    }

    protected byte[] getOutputContent(DocumentWorkerResult workerResult, TaskMessage message, TestItem<TTestInput, DocumentWorkerTestExpectation> testItem) throws Exception {
        ((DocumentWorkerTestExpectation)testItem.getExpectedOutputData()).setResult(this.convert(workerResult, testItem));
        return this.getSerializedTestItem(testItem, this.configuration);
    }

    private DocumentWorkerResultExpectation convert(DocumentWorkerResult result, TestItem<TTestInput, DocumentWorkerTestExpectation> testItem) {
        DocumentWorkerResultExpectation expectation = new DocumentWorkerResultExpectation();
        if (result.fieldChanges != null) {
            expectation.fieldChanges = this.convert(result.fieldChanges, testItem);
        }
        if (result.failures != null) {
            expectation.failures = result.failures;
        }
        return expectation;
    }

    private Map<String, DocumentWorkerFieldChangesExpectation> convert(Map<String, DocumentWorkerFieldChanges> fieldChanges, TestItem<TTestInput, DocumentWorkerTestExpectation> testItem) {
        return fieldChanges.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> this.convert((DocumentWorkerFieldChanges)entry.getValue(), (String)entry.getKey(), testItem)));
    }

    private DocumentWorkerFieldChangesExpectation convert(DocumentWorkerFieldChanges fieldChange, String fieldName, TestItem<TTestInput, DocumentWorkerTestExpectation> testItem) {
        DocumentWorkerFieldChangesExpectation expectation = new DocumentWorkerFieldChangesExpectation();
        expectation.action = fieldChange.action;
        expectation.values = fieldChange.values.stream().map(value -> this.convert((DocumentWorkerFieldValue)value, fieldName, testItem)).collect(Collectors.toList());
        return expectation;
    }

    private DocumentWorkerFieldValueExpectation convert(DocumentWorkerFieldValue fieldValue, String fieldName, TestItem<TTestInput, DocumentWorkerTestExpectation> testItem) {
        DocumentWorkerFieldValueExpectation expectation = new DocumentWorkerFieldValueExpectation();
        expectation.encoding = fieldValue.encoding;
        if (fieldValue.encoding == DocumentWorkerFieldEncoding.storage_ref) {
            expectation.content = this.getContentExpectation(fieldValue.data, fieldName, testItem);
            expectation.data = null;
        } else {
            expectation.content = null;
            expectation.data = fieldValue.data;
        }
        return expectation;
    }

    private ContentFileTestExpectation getContentExpectation(String storageRef, String fieldName, TestItem<TTestInput, DocumentWorkerTestExpectation> testItem) {
        ContentFileTestExpectation expectation = new ContentFileTestExpectation();
        try (InputStream dataStream = this.workerServices.getDataStore().retrieve(storageRef);){
            Path contentFile = this.saveContentFile(testItem, testItem.getTag(), fieldName, dataStream);
            expectation.setExpectedContentFile(contentFile.toString());
            expectation.setComparisonType(ContentComparisonType.BINARY);
            expectation.setExpectedSimilarityPercentage(100);
        }
        catch (DataStoreException | IOException e) {
            System.out.print("Failed To get data stream :" + e.toString());
        }
        return expectation;
    }

    protected Path saveContentFile(TestItem<TTestInput, DocumentWorkerTestExpectation> testItem, String baseFileName, String extension, InputStream dataStream) throws IOException {
        String outputFolder = this.getOutputFolder();
        if (this.configuration.isStoreTestCaseWithInput()) {
            Path path = Paths.get(testItem.getTag(), new String[0]).getParent();
            outputFolder = Paths.get(this.configuration.getTestDataFolder(), path == null ? "" : path.toString()).toString();
        }
        String normalizedBaseFileName = Paths.get(FilenameUtils.normalize((String)baseFileName), new String[0]).getFileName().toString();
        Path contentFile = Paths.get(outputFolder, normalizedBaseFileName + "." + extension + ".content");
        Files.deleteIfExists(contentFile);
        Files.copy(dataStream, contentFile, StandardCopyOption.REPLACE_EXISTING);
        return this.getRelativeLocation(contentFile);
    }

    protected Path getRelativeLocation(Path contentFile) {
        Path relative = Paths.get(this.configuration.getTestDataFolder(), new String[0]).relativize(contentFile);
        return relative;
    }
}

