/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.worker.document.views;

import com.hpe.caf.worker.document.DocumentWorkerDocument;
import com.hpe.caf.worker.document.DocumentWorkerFieldValue;
import com.hpe.caf.worker.document.changelog.MutableDocument;
import com.hpe.caf.worker.document.views.ReadOnlyDocuments;
import com.hpe.caf.worker.document.views.ReadOnlyFailure;
import com.hpe.caf.worker.document.views.ReadOnlyFailures;
import com.hpe.caf.worker.document.views.ReadOnlyFieldValue;
import com.hpe.caf.worker.document.views.ReadOnlyFields;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class ReadOnlyDocument {
    private final String reference;
    private final Map<String, List<ReadOnlyFieldValue>> fields;
    private final List<ReadOnlyFailure> failures;
    private final List<ReadOnlyDocument> subdocuments;

    @Nonnull
    public static ReadOnlyDocument create(Map<String, List<DocumentWorkerFieldValue>> fields) {
        return new ReadOnlyDocument(null, ReadOnlyFields.create(fields), ReadOnlyFailures.none(), ReadOnlyDocuments.none());
    }

    @Nonnull
    public static ReadOnlyDocument create(DocumentWorkerDocument document) {
        if (document == null) {
            return new ReadOnlyDocument(null, ReadOnlyFields.none(), ReadOnlyFailures.none(), ReadOnlyDocuments.none());
        }
        return new ReadOnlyDocument(document.reference, ReadOnlyFields.create(document.fields), ReadOnlyFailures.create(document.failures), ReadOnlyDocuments.create(document.subdocuments));
    }

    @Nonnull
    public static ReadOnlyDocument create(MutableDocument document) {
        Objects.requireNonNull(document);
        return new ReadOnlyDocument(document.getReference(), ReadOnlyFields.createFromMutable(document.getFields()), ReadOnlyFailures.create(document.getFailures()), ReadOnlyDocuments.create(document.getSubdocuments()));
    }

    @Nonnull
    public static ReadOnlyDocument create(String reference) {
        return new ReadOnlyDocument(reference, ReadOnlyFields.none(), ReadOnlyFailures.none(), ReadOnlyDocuments.none());
    }

    private ReadOnlyDocument(String reference, Map<String, List<ReadOnlyFieldValue>> fields, List<ReadOnlyFailure> failures, List<ReadOnlyDocument> subdocuments) {
        this.reference = reference;
        this.fields = fields;
        this.failures = failures;
        this.subdocuments = subdocuments;
    }

    public String getReference() {
        return this.reference;
    }

    @Nonnull
    public Map<String, List<ReadOnlyFieldValue>> getFields() {
        return this.fields;
    }

    @Nonnull
    public List<ReadOnlyFailure> getFailures() {
        return this.failures;
    }

    @Nonnull
    public List<ReadOnlyDocument> getSubdocuments() {
        return this.subdocuments;
    }
}

