/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.worker.document.views;

import com.hpe.caf.worker.document.DocumentWorkerFailure;
import com.hpe.caf.worker.document.views.ReadOnlyFailure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class ReadOnlyFailures {
    private ReadOnlyFailures() {
    }

    @Nonnull
    public static List<ReadOnlyFailure> create(List<DocumentWorkerFailure> failures) {
        return failures == null ? Collections.emptyList() : Collections.unmodifiableList(ReadOnlyFailures.createStream(failures).collect(Collectors.toList()));
    }

    @Nonnull
    public static Stream<ReadOnlyFailure> createStream(List<DocumentWorkerFailure> failures) {
        return failures.stream().map(ReadOnlyFailure::create).filter(Objects::nonNull);
    }

    @Nonnull
    public static List<ReadOnlyFailure> create(ArrayList<ReadOnlyFailure> failures) {
        return Collections.unmodifiableList(failures);
    }

    @Nonnull
    public static List<ReadOnlyFailure> none() {
        return Collections.emptyList();
    }
}

