/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.worker.document.views;

import com.hpe.caf.worker.document.DocumentWorkerFieldEncoding;
import com.hpe.caf.worker.document.DocumentWorkerFieldValue;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class ReadOnlyFieldValue {
    private final DocumentWorkerFieldValue fieldValue;

    @Nonnull
    public static ReadOnlyFieldValue create(DocumentWorkerFieldValue fieldValue) {
        return new ReadOnlyFieldValue(fieldValue);
    }

    private ReadOnlyFieldValue(DocumentWorkerFieldValue fieldValue) {
        this.fieldValue = Objects.requireNonNull(fieldValue);
    }

    @Nonnull
    public String getData() {
        return ReadOnlyFieldValue.nullToEmpty(this.fieldValue.data);
    }

    @Nonnull
    public DocumentWorkerFieldEncoding getEncoding() {
        return ReadOnlyFieldValue.nullToUtf8(this.fieldValue.encoding);
    }

    @Nonnull
    private static String nullToEmpty(String str) {
        return str != null ? str : "";
    }

    @Nonnull
    private static DocumentWorkerFieldEncoding nullToUtf8(DocumentWorkerFieldEncoding encoding) {
        return encoding != null ? encoding : DocumentWorkerFieldEncoding.utf8;
    }
}

