/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.worker.document.changelog;

import com.hpe.caf.worker.document.DocumentWorkerChange;
import com.hpe.caf.worker.document.DocumentWorkerChangeLogEntry;
import com.hpe.caf.worker.document.DocumentWorkerDocument;
import com.hpe.caf.worker.document.DocumentWorkerFailure;
import com.hpe.caf.worker.document.DocumentWorkerFieldValue;
import com.hpe.caf.worker.document.exceptions.InvalidChangeLogException;
import com.hpe.caf.worker.document.exceptions.UnexpectedSubdocumentReferenceException;
import com.hpe.caf.worker.document.views.ReadOnlyDocument;
import com.hpe.caf.worker.document.views.ReadOnlyFailure;
import com.hpe.caf.worker.document.views.ReadOnlyFailures;
import com.hpe.caf.worker.document.views.ReadOnlyFieldValue;
import com.hpe.caf.worker.document.views.ReadOnlyFieldValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class MutableDocument {
    private String reference;
    private final Map<String, ArrayList<ReadOnlyFieldValue>> fields;
    private ArrayList<ReadOnlyFailure> failures;
    private final ArrayList<MutableDocument> subdocuments;

    public MutableDocument(ReadOnlyDocument document) {
        Objects.requireNonNull(document);
        this.reference = document.getReference();
        this.fields = document.getFields().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new ArrayList((Collection)entry.getValue())));
        this.failures = new ArrayList<ReadOnlyFailure>(document.getFailures());
        this.subdocuments = document.getSubdocuments().stream().map(MutableDocument::new).collect(MutableDocument.toArrayList());
    }

    public String getReference() {
        return this.reference;
    }

    @Nonnull
    public Map<String, ArrayList<ReadOnlyFieldValue>> getFields() {
        return this.fields;
    }

    @Nonnull
    public ArrayList<ReadOnlyFailure> getFailures() {
        return this.failures;
    }

    @Nonnull
    public ArrayList<MutableDocument> getSubdocuments() {
        return this.subdocuments;
    }

    public void applyChangeLog(List<DocumentWorkerChangeLogEntry> changeLog) throws InvalidChangeLogException {
        if (changeLog == null) {
            return;
        }
        for (DocumentWorkerChangeLogEntry changeLogEntry : changeLog) {
            this.applyChangeLogEntry(changeLogEntry);
        }
    }

    public void applyChangeLogEntry(DocumentWorkerChangeLogEntry changeLogEntry) throws InvalidChangeLogException {
        if (changeLogEntry == null) {
            return;
        }
        this.applyChanges(changeLogEntry.changes);
    }

    public void applyChanges(List<DocumentWorkerChange> changes) throws InvalidChangeLogException {
        if (changes == null) {
            return;
        }
        for (DocumentWorkerChange change : changes) {
            this.applyChange(change);
        }
    }

    private void applyChange(DocumentWorkerChange change) throws InvalidChangeLogException {
        DocumentWorkerChange.RemoveSubdocumentParams removeSubdocumentParams;
        DocumentWorkerChange.UpdateSubdocumentParams updateSubdocumentParams;
        DocumentWorkerChange.InsertSubdocumentParams insertSubdocumentParams;
        DocumentWorkerDocument addSubdocumentParam;
        List setFailuresParam;
        DocumentWorkerFailure addFailureParam;
        List removeFieldsParam;
        Map setFieldsParam;
        Map addFieldsParam;
        if (change == null) {
            return;
        }
        DocumentWorkerChange.SetReferenceParams setReferenceParams = change.setReference;
        if (setReferenceParams != null) {
            this.setReference(setReferenceParams.value);
        }
        if ((addFieldsParam = change.addFields) != null) {
            this.addFields(addFieldsParam);
        }
        if ((setFieldsParam = change.setFields) != null) {
            this.setFields(setFieldsParam);
        }
        if ((removeFieldsParam = change.removeFields) != null) {
            this.removeFields(removeFieldsParam);
        }
        if ((addFailureParam = change.addFailure) != null) {
            this.addFailure(addFailureParam);
        }
        if ((setFailuresParam = change.setFailures) != null) {
            this.setFailures(setFailuresParam);
        }
        if ((addSubdocumentParam = change.addSubdocument) != null) {
            this.addSubdocument(addSubdocumentParam);
        }
        if ((insertSubdocumentParams = change.insertSubdocument) != null) {
            this.insertSubdocument(insertSubdocumentParams.index, insertSubdocumentParams.subdocument);
        }
        if ((updateSubdocumentParams = change.updateSubdocument) != null) {
            this.updateSubdocument(updateSubdocumentParams.index, updateSubdocumentParams.reference, updateSubdocumentParams.changes);
        }
        if ((removeSubdocumentParams = change.removeSubdocument) != null) {
            this.removeSubdocument(removeSubdocumentParams.index, removeSubdocumentParams.reference);
        }
    }

    private void setReference(String value) {
        this.reference = value;
    }

    private void addFields(Map<String, List<DocumentWorkerFieldValue>> addFields) {
        for (Map.Entry<String, List<DocumentWorkerFieldValue>> addFieldEntry : addFields.entrySet()) {
            String fieldName = addFieldEntry.getKey();
            List<DocumentWorkerFieldValue> fieldValuesToAdd = addFieldEntry.getValue();
            if (fieldValuesToAdd == null) continue;
            List fieldValues = this.fields.get(fieldName);
            Stream<ReadOnlyFieldValue> extraFieldValues = ReadOnlyFieldValues.createStream(fieldValuesToAdd);
            if (fieldValues == null) {
                this.fields.put(fieldName, extraFieldValues.collect(MutableDocument.toArrayList()));
                continue;
            }
            fieldValues.addAll(extraFieldValues.collect(Collectors.toList()));
        }
    }

    private void setFields(Map<String, List<DocumentWorkerFieldValue>> setFields) {
        for (Map.Entry<String, List<DocumentWorkerFieldValue>> setFieldEntry : setFields.entrySet()) {
            String fieldName = setFieldEntry.getKey();
            List<DocumentWorkerFieldValue> fieldValuesToSet = setFieldEntry.getValue();
            if (fieldValuesToSet == null) {
                this.fields.remove(fieldName);
                continue;
            }
            Stream<ReadOnlyFieldValue> newFieldValuesStream = ReadOnlyFieldValues.createStream(fieldValuesToSet);
            ArrayList newFieldValues = newFieldValuesStream.collect(MutableDocument.toArrayList());
            this.fields.put(fieldName, newFieldValues);
        }
    }

    private void removeFields(List<String> removeFields) {
        for (String fieldName : removeFields) {
            this.fields.remove(fieldName);
        }
    }

    private void addFailure(DocumentWorkerFailure addFailure) {
        ReadOnlyFailure failure = ReadOnlyFailure.create(addFailure);
        if (failure != null) {
            this.failures.add(failure);
        }
    }

    private void setFailures(List<DocumentWorkerFailure> setFailures) {
        this.failures = ReadOnlyFailures.createStream(setFailures).collect(MutableDocument.toArrayList());
    }

    private void addSubdocument(DocumentWorkerDocument addSubdocument) {
        ReadOnlyDocument subdocument = ReadOnlyDocument.create(addSubdocument);
        this.subdocuments.add(new MutableDocument(subdocument));
    }

    private void insertSubdocument(int index, DocumentWorkerDocument subdocument) {
        ReadOnlyDocument newSubdocument = ReadOnlyDocument.create(subdocument);
        this.subdocuments.add(index, new MutableDocument(newSubdocument));
    }

    private void updateSubdocument(int index, String reference, List<DocumentWorkerChange> changes) throws InvalidChangeLogException {
        MutableDocument subdocument = this.subdocuments.get(index);
        MutableDocument.checkSubdocumentReference(reference, subdocument.reference);
        subdocument.applyChanges(changes);
    }

    private void removeSubdocument(int index, String reference) throws UnexpectedSubdocumentReferenceException {
        MutableDocument subdocument = this.subdocuments.get(index);
        MutableDocument.checkSubdocumentReference(reference, subdocument.reference);
        this.subdocuments.remove(index);
    }

    private static <T> Collector<T, ?, ArrayList<T>> toArrayList() {
        return Collectors.toCollection(ArrayList::new);
    }

    private static void checkSubdocumentReference(String expectedReference, String actualReference) throws UnexpectedSubdocumentReferenceException {
        if (expectedReference != null && !expectedReference.equals(actualReference)) {
            throw new UnexpectedSubdocumentReferenceException(expectedReference, actualReference);
        }
    }
}

