/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.caf.worker.document.schema.validator;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonNodeReader;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.microfocus.caf.worker.document.schema.model.SchemaResource;
import com.microfocus.caf.worker.document.schema.validator.InvalidDocumentException;
import com.worldturner.medeia.api.JsonSchemaVersion;
import com.worldturner.medeia.api.SchemaSource;
import com.worldturner.medeia.api.StreamSchemaSource;
import com.worldturner.medeia.api.jackson.MedeiaJacksonApi;
import com.worldturner.medeia.schema.validation.SchemaValidator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;

public final class DocumentValidator {
    public static void validate(String document) throws InvalidDocumentException {
        try (InputStream inputStream = SchemaResource.getUrl().openStream();
             StringReader documentReader = new StringReader(document);){
            JsonNode documentSchema = new JsonNodeReader().fromInputStream(inputStream);
            JsonNode documentNode = new JsonNodeReader().fromReader((Reader)documentReader);
            ProcessingReport report = JsonSchemaFactory.byDefault().getValidator().validateUnchecked(documentSchema, documentNode);
            boolean isSuccess = report.isSuccess();
            if (!isSuccess) {
                StringBuilder errMsg = new StringBuilder("Document validation errors:");
                for (ProcessingMessage msg : report) {
                    if (msg.getLogLevel() != LogLevel.ERROR && msg.getLogLevel() != LogLevel.FATAL) continue;
                    errMsg.append('\n').append(msg.getMessage());
                }
                throw new InvalidDocumentException(errMsg.toString());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static JsonParser getValidatingParser(InputStream document) throws JsonParseException, IOException {
        MedeiaJacksonApi api = new MedeiaJacksonApi();
        StreamSchemaSource source = new StreamSchemaSource(SchemaResource.getUrl().openStream(), JsonSchemaVersion.DRAFT07);
        SchemaValidator validator = api.loadSchema((SchemaSource)source);
        JsonFactory factory = new JsonFactory();
        factory.configure(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM, false);
        factory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        JsonParser unvalidatedParser = factory.createParser(document);
        return api.decorateJsonParser(validator, unvalidatedParser);
    }
}

