/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.worker.markup;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.hpe.caf.util.ref.ReferencedData;
import com.hpe.caf.worker.markup.MarkupTestExpectation;
import com.hpe.caf.worker.markup.MarkupTestInput;
import com.hpe.caf.worker.markup.MarkupWorkerTask;
import com.hpe.caf.worker.testing.FileInputWorkerTaskFactory;
import com.hpe.caf.worker.testing.TestConfiguration;
import com.hpe.caf.worker.testing.TestItem;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class MarkupWorkerTaskFactory
extends FileInputWorkerTaskFactory<MarkupWorkerTask, MarkupTestInput, MarkupTestExpectation> {
    public MarkupWorkerTaskFactory(TestConfiguration configuration) throws Exception {
        super(configuration);
    }

    public String getWorkerName() {
        return "MarkupWorker";
    }

    public int getApiVersion() {
        return 1;
    }

    protected MarkupWorkerTask createTask(TestItem<MarkupTestInput, MarkupTestExpectation> testItem, ReferencedData sourceData) {
        MarkupWorkerTask task = new MarkupWorkerTask();
        if (((MarkupTestInput)((Object)testItem.getInputData())).getSourceData() == null) {
            ((MarkupTestInput)((Object)testItem.getInputData())).setSourceData((Multimap<String, String>)LinkedListMultimap.create());
        }
        ArrayListMultimap sourceDataMap = ArrayListMultimap.create();
        for (Map.Entry sourceDataEntry : ((MarkupTestInput)((Object)testItem.getInputData())).getSourceData().entries()) {
            String key = (String)sourceDataEntry.getKey();
            String value = (String)sourceDataEntry.getValue();
            ReferencedData refData = ReferencedData.getWrappedData((byte[])value.getBytes(StandardCharsets.UTF_8));
            sourceDataMap.put((Object)key, (Object)refData);
        }
        String contentFieldName = ((MarkupTestInput)((Object)testItem.getInputData())).getContentFieldName();
        if (Strings.isNullOrEmpty((String)contentFieldName)) {
            contentFieldName = "CONTENT";
        }
        if (!sourceDataMap.containsKey((Object)contentFieldName)) {
            sourceDataMap.put((Object)contentFieldName, (Object)sourceData);
        }
        task.sourceData = sourceDataMap;
        task.hashConfiguration = ((MarkupTestInput)((Object)testItem.getInputData())).getHashConfiguration();
        task.outputFields = ((MarkupTestInput)((Object)testItem.getInputData())).getOutputFieldList();
        task.isEmail = ((MarkupTestInput)((Object)testItem.getInputData())).isEmail();
        return task;
    }
}

