/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.worker.markup;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.hpe.caf.util.ref.ReferencedData;
import com.hpe.caf.worker.markup.Field;
import com.hpe.caf.worker.markup.HashConfiguration;
import com.hpe.caf.worker.markup.HashFunction;
import com.hpe.caf.worker.markup.MarkupTestExpectation;
import com.hpe.caf.worker.markup.MarkupTestInput;
import com.hpe.caf.worker.markup.MarkupWorkerResult;
import com.hpe.caf.worker.markup.MarkupWorkerTask;
import com.hpe.caf.worker.markup.NormalizationType;
import com.hpe.caf.worker.markup.OutputField;
import com.hpe.caf.worker.markup.Scope;
import com.hpe.caf.worker.testing.TestConfiguration;
import com.hpe.caf.worker.testing.TestItem;
import com.hpe.caf.worker.testing.preparation.PreparationItemProvider;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class MarkupResultPreparationProvider
extends PreparationItemProvider<MarkupWorkerTask, MarkupWorkerResult, MarkupTestInput, MarkupTestExpectation> {
    public MarkupResultPreparationProvider(TestConfiguration<MarkupWorkerTask, MarkupWorkerResult, MarkupTestInput, MarkupTestExpectation> configuration) {
        super(configuration);
    }

    protected TestItem<MarkupTestInput, MarkupTestExpectation> createTestItem(Path inputFile, Path expectedFile) throws Exception {
        TestItem item = super.createTestItem(inputFile, expectedFile);
        MarkupWorkerTask task = (MarkupWorkerTask)this.getTaskTemplate();
        if (task == null) {
            HashConfiguration hashConfiguration = new HashConfiguration();
            hashConfiguration.fields = new ArrayList();
            Field f1 = new Field();
            f1.name = "to";
            f1.normalizationType = NormalizationType.NONE;
            Field f2 = new Field();
            f2.name = "body";
            f2.normalizationType = NormalizationType.REMOVE_WHITESPACE;
            hashConfiguration.fields.add(f1);
            hashConfiguration.fields.add(f2);
            hashConfiguration.name = "Normalized";
            hashConfiguration.scope = Scope.EMAIL_SPECIFIC;
            hashConfiguration.hashFunctions = new ArrayList();
            hashConfiguration.hashFunctions.add(HashFunction.XXHASH64);
            Field f4 = new Field();
            f4.name = "cc";
            f4.normalizationType = NormalizationType.NONE;
            Field f5 = new Field();
            f5.name = "subject";
            f5.normalizationType = NormalizationType.NONE;
            Field f6 = new Field();
            f6.name = "sent";
            f6.normalizationType = NormalizationType.REMOVE_WHITESPACE;
            ArrayList<Field> fieldsTwo = new ArrayList<Field>();
            fieldsTwo.add(f4);
            fieldsTwo.add(f5);
            fieldsTwo.add(f6);
            HashConfiguration hashConfigurationTwo = new HashConfiguration();
            hashConfigurationTwo.name = "Varient";
            hashConfigurationTwo.scope = Scope.EMAIL_THREAD;
            hashConfigurationTwo.fields = fieldsTwo;
            hashConfigurationTwo.hashFunctions = new ArrayList();
            hashConfigurationTwo.hashFunctions.add(HashFunction.XXHASH64);
            ArrayList<HashConfiguration> config = new ArrayList<HashConfiguration>();
            config.add(hashConfiguration);
            config.add(hashConfigurationTwo);
            ArrayList<OutputField> outputFieldList = new ArrayList<OutputField>();
            OutputField of1 = new OutputField();
            of1.field = "EXAMPLE_FIELD_NAME";
            of1.xPathExpression = ".";
            outputFieldList.add(of1);
            ((MarkupTestInput)((Object)item.getInputData())).setSourceData((Multimap<String, String>)LinkedListMultimap.create());
            ((MarkupTestInput)((Object)item.getInputData())).setHashConfiguration(config);
            ((MarkupTestInput)((Object)item.getInputData())).setOutputFieldList(outputFieldList);
            ((MarkupTestInput)((Object)item.getInputData())).setEmail(true);
        } else {
            this.updateItem((TestItem<MarkupTestInput, MarkupTestExpectation>)item, task);
        }
        return item;
    }

    private void updateItem(TestItem<MarkupTestInput, MarkupTestExpectation> item, MarkupWorkerTask task) throws Exception {
        LinkedListMultimap sourceDataMap = LinkedListMultimap.create();
        for (Map.Entry sourceDataEntry : task.sourceData.entries()) {
            String storageReference = ((ReferencedData)sourceDataEntry.getValue()).getReference();
            if (storageReference == null || storageReference.isEmpty()) {
                String key = (String)sourceDataEntry.getKey();
                String value = IOUtils.toString((byte[])((ReferencedData)sourceDataEntry.getValue()).getData(), (String)"UTF-8");
                sourceDataMap.put((Object)key, (Object)value);
                continue;
            }
            throw new Exception("Storage references not supported in markup worker tests.");
        }
        ((MarkupTestInput)((Object)item.getInputData())).setSourceData((Multimap<String, String>)sourceDataMap);
        ((MarkupTestInput)((Object)item.getInputData())).setHashConfiguration(task.hashConfiguration);
        ((MarkupTestInput)((Object)item.getInputData())).setOutputFieldList(task.outputFields);
        ((MarkupTestInput)((Object)item.getInputData())).setEmail(task.isEmail);
    }
}

