/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.worker.markup;

import com.github.cafdataprocessing.worker.markup.core.EmailSplitter;
import com.github.cafdataprocessing.worker.markup.core.MarkupDocumentEngine;
import com.github.cafdataprocessing.worker.markup.core.MarkupWorkerConfiguration;
import com.github.cafdataprocessing.worker.markup.core.exceptions.AddHeadersException;
import com.github.cafdataprocessing.worker.markup.core.exceptions.MappingException;
import com.hpe.caf.api.Codec;
import com.hpe.caf.api.ConfigurationException;
import com.hpe.caf.api.worker.DataStore;
import com.hpe.caf.api.worker.InvalidTaskException;
import com.hpe.caf.api.worker.TaskRejectedException;
import com.hpe.caf.api.worker.WorkerResponse;
import com.hpe.caf.api.worker.WorkerTaskData;
import com.hpe.caf.worker.AbstractWorker;
import com.hpe.caf.worker.markup.MarkupWorkerResult;
import com.hpe.caf.worker.markup.MarkupWorkerStatus;
import com.hpe.caf.worker.markup.MarkupWorkerTask;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkupWorker
extends AbstractWorker<MarkupWorkerTask, MarkupWorkerResult> {
    private final MarkupWorkerConfiguration config;
    private final MarkupDocumentEngine markupDocument;
    private static final Logger LOG = LoggerFactory.getLogger(MarkupWorker.class);
    private final DataStore dataStore;
    private final EmailSplitter emailSplitter;

    public MarkupWorker(MarkupWorkerTask task, DataStore dataStore, String outputQueue, Codec codec, MarkupWorkerConfiguration config, MarkupDocumentEngine markupDocument, EmailSplitter emailSplitter, WorkerTaskData workerTaskData) throws InvalidTaskException {
        super((Object)task, outputQueue, codec, workerTaskData);
        this.dataStore = Objects.requireNonNull(dataStore);
        this.config = config;
        this.markupDocument = markupDocument;
        this.emailSplitter = emailSplitter;
    }

    public String getWorkerIdentifier() {
        return "MarkupWorker";
    }

    public int getWorkerApiVersion() {
        return 1;
    }

    public WorkerResponse doWork() throws InterruptedException, TaskRejectedException {
        MarkupWorkerResult result = this.processInput();
        if (result.workerStatus == MarkupWorkerStatus.COMPLETED) {
            return this.createSuccessResult(result);
        }
        return this.createFailureResult(result);
    }

    private MarkupWorkerResult processInput() throws InterruptedException {
        LOG.info("Starting work");
        try {
            return this.markupDocument.markupDocument((MarkupWorkerTask)this.getTask(), this.dataStore, this.getCodec(), this.config, this.emailSplitter);
        }
        catch (JDOMException jdome) {
            LOG.error("Error during JDOM parsing. ", (Throwable)jdome);
            return MarkupWorker.createErrorResult(MarkupWorkerStatus.WORKER_FAILED);
        }
        catch (ExecutionException ee) {
            LOG.error("Error during splitting of emails. ", (Throwable)ee);
            return MarkupWorker.createErrorResult(MarkupWorkerStatus.WORKER_FAILED);
        }
        catch (ConfigurationException ex) {
            LOG.error("Error during retrieval of configuration. ", (Throwable)ex);
            return MarkupWorker.createErrorResult(MarkupWorkerStatus.WORKER_FAILED);
        }
        catch (AddHeadersException ex) {
            LOG.error("Error adding headers to email. ", (Throwable)ex);
            return MarkupWorker.createErrorResult(MarkupWorkerStatus.WORKER_FAILED);
        }
        catch (MappingException ex) {
            LOG.error("Error mapping input fields for markup. ", (Throwable)ex);
            return MarkupWorker.createErrorResult(MarkupWorkerStatus.WORKER_FAILED);
        }
    }

    private static MarkupWorkerResult createErrorResult(MarkupWorkerStatus status) {
        MarkupWorkerResult workerResult = new MarkupWorkerResult();
        workerResult.workerStatus = status;
        return workerResult;
    }
}

