/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.worker.markup;

import com.github.cafdataprocessing.worker.markup.core.EmailSplitter;
import com.github.cafdataprocessing.worker.markup.core.MarkupDocumentEngine;
import com.github.cafdataprocessing.worker.markup.core.MarkupWorkerConfiguration;
import com.github.cafdataprocessing.worker.markup.core.MarkupWorkerHealthCheck;
import com.hpe.caf.api.Codec;
import com.hpe.caf.api.ConfigurationException;
import com.hpe.caf.api.ConfigurationSource;
import com.hpe.caf.api.HealthResult;
import com.hpe.caf.api.worker.DataStore;
import com.hpe.caf.api.worker.InvalidTaskException;
import com.hpe.caf.api.worker.Worker;
import com.hpe.caf.api.worker.WorkerException;
import com.hpe.caf.api.worker.WorkerTaskData;
import com.hpe.caf.worker.AbstractWorkerFactory;
import com.hpe.caf.worker.markup.MarkupWorker;
import com.hpe.caf.worker.markup.MarkupWorkerTask;

public class MarkupWorkerFactory
extends AbstractWorkerFactory<MarkupWorkerConfiguration, MarkupWorkerTask> {
    private final MarkupWorkerConfiguration config;
    private final MarkupDocumentEngine markupDocument;
    private final EmailSplitter emailSplitter = new EmailSplitter();

    public MarkupWorkerFactory(ConfigurationSource configSource, DataStore store, Codec codec) throws WorkerException {
        super(configSource, store, codec, MarkupWorkerConfiguration.class, MarkupWorkerTask.class);
        this.config = MarkupWorkerFactory.getMarkupWorkerConfig(configSource);
        this.markupDocument = new MarkupDocumentEngine();
    }

    protected String getWorkerName() {
        return "MarkupWorker";
    }

    protected int getWorkerApiVersion() {
        return 1;
    }

    public Worker createWorker(MarkupWorkerTask task, WorkerTaskData workerTaskData) throws InvalidTaskException {
        return new MarkupWorker(task, this.getDataStore(), ((MarkupWorkerConfiguration)this.getConfiguration()).getOutputQueue(), this.getCodec(), this.config, this.markupDocument, this.emailSplitter, workerTaskData);
    }

    public String getInvalidTaskQueue() {
        return ((MarkupWorkerConfiguration)this.getConfiguration()).getOutputQueue();
    }

    public int getWorkerThreads() {
        return ((MarkupWorkerConfiguration)this.getConfiguration()).getThreads();
    }

    public HealthResult healthCheck() {
        MarkupWorkerHealthCheck healthCheck = new MarkupWorkerHealthCheck();
        return healthCheck.healthCheck();
    }

    private static MarkupWorkerConfiguration getMarkupWorkerConfig(ConfigurationSource configSource) throws WorkerException {
        try {
            return (MarkupWorkerConfiguration)configSource.getConfiguration(MarkupWorkerConfiguration.class);
        }
        catch (ConfigurationException ce) {
            throw new WorkerException("Failed to initialise Markup Worker configuration", (Throwable)ce);
        }
    }
}

