/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.workflow.testing;

import com.github.cafdataprocessing.workflow.testing.ActionExpectation;
import com.google.common.base.Strings;
import com.hpe.caf.api.worker.WorkerException;
import com.hpe.caf.worker.document.exceptions.DocumentWorkerTransientException;
import com.hpe.caf.worker.document.extensibility.DocumentWorker;
import com.hpe.caf.worker.document.model.Document;
import com.hpe.caf.worker.document.model.Failure;
import com.hpe.caf.worker.document.model.Field;
import com.hpe.caf.worker.document.model.Response;
import com.hpe.caf.worker.document.model.Script;
import com.hpe.caf.worker.document.model.Scripts;
import com.hpe.caf.worker.document.scripting.events.TaskEventObject;
import com.hpe.caf.worker.document.testing.DocumentBuilder;
import com.hpe.caf.worker.document.testing.FieldsBuilder;
import com.oracle.truffle.js.scriptengine.GraalJSScriptEngine;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import javax.script.Invocable;
import org.apache.commons.io.FileUtils;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.io.IOAccess;
import org.junit.jupiter.api.Assertions;

public class WorkflowTestExecutor {
    public void assertWorkflowActionsExecuted(String workflowName, DocumentWorker documentWorker, Map<String, String[]> fields, Map<String, String> customData, List<ActionExpectation> actionExpectations) {
        this.assertWorkflowActionsExecuted(workflowName, documentWorker, fields, customData, null, actionExpectations);
    }

    public void assertWorkflowActionsExecuted(String workflowName, DocumentWorker documentWorker, Map<String, String[]> fields, Map<String, String> customData, String[] completedActions, List<ActionExpectation> actionExpectations) {
        DocumentBuilder documentBuilder = DocumentBuilder.configure();
        FieldsBuilder fieldsBuilder = documentBuilder.withFields();
        for (Map.Entry<String, String[]> entry : fields.entrySet()) {
            for (String value : entry.getValue()) {
                fieldsBuilder.addFieldValue(entry.getKey(), value);
            }
        }
        if (completedActions != null) {
            for (String completedAction : completedActions) {
                fieldsBuilder.addFieldValue("CAF_WORKFLOW_ACTIONS_COMPLETED", completedAction);
            }
        }
        try {
            this.assertWorkflowActionsExecuted(workflowName, documentWorker, documentBuilder.build(), customData, actionExpectations);
        }
        catch (WorkerException e) {
            throw new RuntimeException(e);
        }
    }

    public void assertWorkflowActionsExecuted(String workflowName, DocumentWorker documentWorker, Document originalDocument, Map<String, String> customData, List<ActionExpectation> actionExpectations) {
        Document documentForExecution = this.cloneDocument(originalDocument, workflowName, customData);
        try {
            documentWorker.processDocument(documentForExecution);
            Assertions.assertEquals((int)0, (int)documentForExecution.getFailures().size(), (String)this.failuresToString(documentForExecution));
            WorkflowTestExecutor.executeOnAfterProcessTaskScript(documentForExecution);
        }
        catch (DocumentWorkerTransientException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (actionExpectations == null || actionExpectations.size() == 0) {
            Assertions.assertEquals((int)0, (int)documentForExecution.getField("CAF_WORKFLOW_ACTION").getValues().size(), (String)"No actions to execute was expected.");
        }
        this.validateAction(actionExpectations.get(0), documentForExecution);
        if (actionExpectations.size() > 1) {
            for (int index = 1; index < actionExpectations.size(); ++index) {
                try {
                    String action = (String)documentForExecution.getField("CAF_WORKFLOW_ACTION").getStringValues().get(0);
                    List completedActions = documentForExecution.getField("CAF_WORKFLOW_ACTIONS_COMPLETED").getStringValues();
                    documentForExecution = this.cloneDocument(originalDocument, workflowName, customData);
                    documentForExecution.getField("CAF_WORKFLOW_ACTION").add(action);
                    for (String completedAction : completedActions) {
                        documentForExecution.getField("CAF_WORKFLOW_ACTIONS_COMPLETED").add(completedAction);
                    }
                    documentWorker.processDocument(documentForExecution);
                    Assertions.assertEquals((int)0, (int)documentForExecution.getFailures().size(), (String)this.failuresToString(documentForExecution));
                    WorkflowTestExecutor.executeOnAfterProcessTaskScript(documentForExecution);
                }
                catch (DocumentWorkerTransientException | InterruptedException e) {
                    throw new RuntimeException(e);
                }
                this.validateAction(actionExpectations.get(index), documentForExecution);
            }
        }
        try {
            documentWorker.processDocument(documentForExecution);
            WorkflowTestExecutor.executeOnAfterProcessTaskScript(documentForExecution);
        }
        catch (DocumentWorkerTransientException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (documentForExecution.getField("CAF_WORKFLOW_ACTION").getValues().size() > 0) {
            Assertions.fail((String)String.format("Action [%s] was not defined in the action expectations.", documentForExecution.getField("CAF_WORKFLOW_ACTION").getStringValues().get(0)));
        }
    }

    private void validateAction(ActionExpectation actionExpectation, Document document) {
        Field actionToExecuteField = document.getField("CAF_WORKFLOW_ACTION");
        Assertions.assertEquals((int)1, (int)actionToExecuteField.getValues().size(), (String)(actionExpectation.getAction() + " not marked for execution."));
        Assertions.assertEquals((Object)actionExpectation.getAction(), actionToExecuteField.getStringValues().get(0), (String)"Expected action not found.");
        Response response = document.getTask().getResponse();
        if (actionExpectation.getCustomData() != null) {
            for (Map.Entry<String, String> entry : actionExpectation.getCustomData().entrySet()) {
                Assertions.assertEquals((Object)entry.getValue(), (Object)response.getCustomData().get(entry.getKey()), (String)String.format("Action [%s] argument [%s] not as expected.", actionExpectation.getAction(), entry.getKey()));
            }
        }
        Assertions.assertEquals((Object)actionExpectation.getSuccessQueue(), (Object)response.getSuccessQueue().getName(), (String)(actionExpectation.getAction() + " success queue not as expected."));
        Assertions.assertEquals((Object)actionExpectation.getFailureQueue(), (Object)response.getFailureQueue().getName(), (String)(actionExpectation.getAction() + " failure queue not as expected."));
    }

    private static void executeOnAfterProcessTaskScript(Document document) {
        Scripts scripts = document.getTask().getScripts();
        Script inlineScript = scripts.get(0);
        Assertions.assertEquals((Object)"temp-workflow.js", (Object)inlineScript.getName());
        GraalJSScriptEngine scriptEngine = GraalJSScriptEngine.create(null, (Context.Builder)Context.newBuilder((String[])new String[]{"js"}).allowExperimentalOptions(true).allowHostAccess(HostAccess.ALL).allowHostClassLookup(s -> true).allowIO(IOAccess.ALL).option("js.load-from-classpath", "true"));
        Invocable invocable = (Invocable)scriptEngine;
        Path p = Paths.get("target", "workflow.js");
        try {
            FileUtils.write((File)p.toFile(), (CharSequence)inlineScript.getScript(), (Charset)StandardCharsets.UTF_8);
            scriptEngine.eval("load('" + p.toString().replace("\\", "\\\\") + "');");
            TaskEventObject taskEventObject = new TaskEventObject(document.getTask());
            invocable.invokeFunction("onAfterProcessTask", taskEventObject);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private String failuresToString(Document document) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Failure failure : document.getFailures()) {
            stringBuilder.append(failure.getFailureMessage());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private Document cloneDocument(Document document, String workflowName, Map<String, String> customData) {
        DocumentBuilder documentBuilder = DocumentBuilder.configure();
        if (!Strings.isNullOrEmpty((String)workflowName)) {
            documentBuilder.withCustomData().add("workflowName", workflowName);
        }
        if (customData != null) {
            for (Map.Entry<String, String> entry : customData.entrySet()) {
                documentBuilder.withCustomData().add(entry.getKey(), entry.getValue());
            }
        }
        this.cloneDocument(document, documentBuilder);
        try {
            return documentBuilder.build();
        }
        catch (WorkerException e) {
            throw new RuntimeException(e);
        }
    }

    private void cloneDocument(Document document, DocumentBuilder documentBuilder) {
        this.cloneFields(document, documentBuilder.withFields());
        for (Document subdocument : document.getSubdocuments()) {
            DocumentBuilder subdocumentBuilder = DocumentBuilder.configure();
            documentBuilder.withSubDocuments(new DocumentBuilder[]{subdocumentBuilder});
            this.cloneDocument(subdocument, subdocumentBuilder);
        }
    }

    private void cloneFields(Document document, FieldsBuilder fieldsBuilder) {
        for (Field field : document.getFields()) {
            for (String fieldValue : field.getStringValues()) {
                fieldsBuilder.addFieldValue(field.getName(), fieldValue);
            }
        }
    }
}

