/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.workflow.testing.models;

import com.github.cafdataprocessing.workflow.testing.models.FieldMock;
import com.github.cafdataprocessing.workflow.testing.models.FieldsMock;
import com.github.cafdataprocessing.workflow.testing.models.SubdocumentsMock;
import com.hpe.caf.worker.document.model.Application;
import com.hpe.caf.worker.document.model.Document;
import com.hpe.caf.worker.document.model.Failures;
import com.hpe.caf.worker.document.model.Field;
import com.hpe.caf.worker.document.model.Fields;
import com.hpe.caf.worker.document.model.Subdocuments;
import com.hpe.caf.worker.document.model.Task;
import java.util.Map;

public class DocumentMock
implements Document {
    private String reference;
    private Fields fields;
    private final Task task;
    private final Map<String, String> customData;
    private final Failures failures;
    private final Subdocuments subdocuments;
    private final Application application;
    private final Document parentDocument;
    private Document rootDocument;

    public DocumentMock(String reference, Fields fields, Task task, Map<String, String> customData, Failures failures, Subdocuments subdocuments, Application application, Document parentDocument, Document rootDocument) {
        this.reference = reference;
        this.fields = fields;
        this.task = task;
        this.customData = customData;
        this.failures = failures;
        this.subdocuments = subdocuments == null ? new SubdocumentsMock() : subdocuments;
        this.application = application;
        this.parentDocument = parentDocument;
        this.rootDocument = rootDocument;
    }

    public Task getTask() {
        return this.task;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public void resetReference() {
        this.reference = null;
    }

    public Fields getFields() {
        return this.fields;
    }

    public Field getField(String fieldName) {
        return this.fields.stream().filter(f -> f.getName().equals(fieldName)).findFirst().orElseGet(() -> {
            FieldMock fieldMocked = new FieldMock(this, fieldName, this.application);
            FieldsMock fields = (FieldsMock)this.fields;
            fields.addField(fieldMocked);
            return fieldMocked;
        });
    }

    public String getCustomData(String dataKey) {
        return this.customData.get(dataKey);
    }

    public Failures getFailures() {
        return this.failures;
    }

    public void addFailure(String failureId, String failureMessage) {
        this.failures.add(failureId, failureMessage);
    }

    public Document getParentDocument() {
        return this.parentDocument;
    }

    public Document getRootDocument() {
        return this.rootDocument;
    }

    public Subdocuments getSubdocuments() {
        return this.subdocuments;
    }

    public boolean hasSubdocuments() {
        if (this.subdocuments == null) {
            return false;
        }
        return !this.subdocuments.isEmpty();
    }

    public boolean hasChanges() {
        return true;
    }

    public void reset() {
    }

    public Application getApplication() {
        return this.application;
    }

    public void setFields(Fields fields) {
        this.fields = fields;
    }

    public void setRootDocument(Document rootDocument) {
        this.rootDocument = rootDocument;
    }
}

