/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.workflow.testing.models;

import com.github.cafdataprocessing.workflow.testing.models.FieldValuesMock;
import com.hpe.caf.worker.document.model.Application;
import com.hpe.caf.worker.document.model.Document;
import com.hpe.caf.worker.document.model.Field;
import com.hpe.caf.worker.document.model.FieldValues;
import java.util.ArrayList;
import java.util.List;

public class FieldMock
implements Field {
    private List<String> values;
    private final List<String> originalValuesBeforeChanges;
    private final Document documentThisFieldIsAssociatedWith;
    private final String name;
    private boolean hasChanged;
    private final Application application;

    public FieldMock(List<String> values, Document documentThisFieldIsAssociatedWith, String name, Application application) {
        this.values = values;
        this.originalValuesBeforeChanges = new ArrayList<String>(values);
        this.documentThisFieldIsAssociatedWith = documentThisFieldIsAssociatedWith;
        this.name = name;
        this.hasChanged = false;
        this.application = application;
    }

    public FieldMock(Document documentThisFieldIsAssociatedWith, String name, Application application) {
        this.values = new ArrayList<String>();
        this.originalValuesBeforeChanges = new ArrayList<String>(this.values);
        this.documentThisFieldIsAssociatedWith = documentThisFieldIsAssociatedWith;
        this.name = name;
        this.hasChanged = false;
        this.application = application;
    }

    public void add(String data) {
        this.values.add(data);
        this.hasChanged = true;
    }

    public void add(byte[] data) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addReference(String dataRef) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void clear() {
        this.values.clear();
        this.hasChanged = true;
    }

    public Document getDocument() {
        return this.documentThisFieldIsAssociatedWith;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getStringValues() {
        return this.values;
    }

    public FieldValues getValues() {
        return new FieldValuesMock(this, this.values);
    }

    public boolean hasChanges() {
        return this.hasChanged;
    }

    public boolean hasValues() {
        return !this.values.isEmpty();
    }

    public void set(String data) {
        this.values.clear();
        this.values.add(data);
        this.hasChanged = true;
    }

    public void set(byte[] data) {
        this.set(new String(data));
    }

    public void setReference(String dataRef) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void reset() {
        this.values = new ArrayList<String>(this.originalValuesBeforeChanges);
        this.hasChanged = false;
    }

    public Application getApplication() {
        return this.application;
    }
}

