/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.workflow.testing.models;

import com.github.cafdataprocessing.workflow.testing.models.FieldMock;
import com.hpe.caf.worker.document.model.Application;
import com.hpe.caf.worker.document.model.Document;
import com.hpe.caf.worker.document.model.Field;
import com.hpe.caf.worker.document.model.Fields;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FieldsMock
implements Fields {
    private List<Field> fields;
    private final List<Field> originalFields;
    private final Application application;
    private final Document document;

    public FieldsMock(List<Field> fields, Application application, Document document) {
        this.fields = fields;
        this.originalFields = new ArrayList<Field>(fields);
        this.application = application;
        this.document = document;
    }

    public FieldsMock(Fields fields, Application application, Document document) {
        this.fields = fields.stream().collect(Collectors.toList());
        this.originalFields = new ArrayList<Field>(this.fields);
        this.application = application;
        this.document = document;
    }

    public Field get(String fieldName) {
        return this.fields.stream().filter(f -> f.getName().equals(fieldName)).findAny().orElseGet(() -> new FieldMock(this.document, fieldName, this.application));
    }

    public Document getDocument() {
        return this.document;
    }

    public void reset() {
        this.fields = new ArrayList<Field>(this.originalFields);
    }

    public Stream<Field> stream() {
        return this.fields.stream();
    }

    public Application getApplication() {
        return this.application;
    }

    public Iterator<Field> iterator() {
        return this.fields.iterator();
    }

    public void addField(Field field) {
        this.fields.add(field);
    }
}

